/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.FileRef;
import java.nio.file.FileSystem;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import sun.nio.fs.DefaultFileSystemProvider;

public final class FileSystems {
    private FileSystems() {
    }

    public static FileSystem getDefault() {
        return DefaultFileSystemHolder.defaultFileSystem;
    }

    public static FileSystem getFileSystem(URI uRI) {
        String string = uRI.getScheme();
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!string.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
            return fileSystemProvider.getFileSystem(uRI);
        }
        throw new ProviderNotFoundException("Provider \"" + string + "\" not found");
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        return FileSystems.newFileSystem(uRI, map, null);
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map, ClassLoader classLoader) throws IOException {
        String string = uRI.getScheme();
        for (FileSystemProvider object : FileSystemProvider.installedProviders()) {
            if (!string.equalsIgnoreCase(object.getScheme())) continue;
            return object.newFileSystem(uRI, map);
        }
        if (classLoader != null) {
            ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class, classLoader);
            Iterator iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                FileSystemProvider fileSystemProvider = (FileSystemProvider)iterator.next();
                if (!string.equalsIgnoreCase(fileSystemProvider.getScheme())) continue;
                return fileSystemProvider.newFileSystem(uRI, map);
            }
        }
        throw new ProviderNotFoundException("Provider \"" + string + "\" not found");
    }

    public static FileSystem newFileSystem(FileRef fileRef, Map<String, ?> map, ClassLoader classLoader) throws IOException {
        if (fileRef == null) {
            throw new NullPointerException();
        }
        for (FileSystemProvider object : FileSystemProvider.installedProviders()) {
            try {
                return object.newFileSystem(fileRef, map);
            }
            catch (UnsupportedOperationException fileSystemProvider) {
            }
        }
        if (classLoader != null) {
            ServiceLoader<FileSystemProvider> serviceLoader = ServiceLoader.load(FileSystemProvider.class, classLoader);
            Iterator iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                FileSystemProvider fileSystemProvider = (FileSystemProvider)iterator.next();
                try {
                    return fileSystemProvider.newFileSystem(fileRef, map);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        throw new ProviderNotFoundException("Provider not found");
    }

    private static class DefaultFileSystemHolder {
        static final FileSystem defaultFileSystem = DefaultFileSystemHolder.defaultFileSystem();

        private DefaultFileSystemHolder() {
        }

        private static FileSystem defaultFileSystem() {
            FileSystemProvider fileSystemProvider = AccessController.doPrivileged(new PrivilegedAction<FileSystemProvider>(){

                @Override
                public FileSystemProvider run() {
                    return DefaultFileSystemHolder.getDefaultProvider();
                }
            });
            return fileSystemProvider.getFileSystem(URI.create("file:///"));
        }

        private static FileSystemProvider getDefaultProvider() {
            FileSystemProvider fileSystemProvider = DefaultFileSystemProvider.create();
            String string = System.getProperty("java.nio.file.spi.DefaultFileSystemProvider");
            if (string != null) {
                for (String string2 : string.split(",")) {
                    try {
                        Class<?> clazz = Class.forName(string2, true, ClassLoader.getSystemClassLoader());
                        Constructor<?> constructor = clazz.getDeclaredConstructor(FileSystemProvider.class);
                        fileSystemProvider = (FileSystemProvider)constructor.newInstance(fileSystemProvider);
                        if (fileSystemProvider.getScheme().equals("file")) continue;
                        throw new Error("Default provider must use scheme 'file'");
                    }
                    catch (Exception exception) {
                        throw new Error(exception);
                    }
                }
            }
            return fileSystemProvider;
        }
    }
}

