package gnu.trove.generate;

import java.io.*;
import java.net.URL;
import java.util.regex.Pattern;

/**
 * Created by IntelliJ IDEA.
 * User: Alexey
 * Date: 19.09.2004
 * Time: 12:26:43
 * To change this template use File | Settings | File Templates.
 */
public class Generate {
  private static final String P2P_MAP_DECORATOR_NAME = "P2PMapDecorator.template";
  private static final String[] WRAPPERS = new String[]{
      // v         V
      "double", "Double",
      "float", "Float",
      "int", "Integer",
      "long", "Long",
  };

  public static void main(String[] args) throws IOException {
    generateP2PMapDecorators();

    generate("P2OMapDecorator.template", "src/gnu/trove/decorator/T", "ObjectHashMapDecorator.java");
    generate("O2PMapDecorator.template", "src/gnu/trove/decorator/TObject", "HashMapDecorator.java");
    generate("SetDecorator.template", "src/gnu/trove/decorator/T", "HashSetDecorator.java");

    generate("P2OHashMap.template", "src/gnu/trove/T", "ObjectHashMap.java");
    generate("O2PHashMap.template", "src/gnu/trove/TObject", "HashMap.java");
    generate("TArrayList.template", "src/gnu/trove/T", "ArrayList.java");
  }

  private static void generate(String templateName, String pathPrefix, String pathSuffix) throws IOException {
    String template = readFile(templateName);
    for (int i = 0; i < WRAPPERS.length; i += 2) {
      String e = WRAPPERS[i];
      String ET = WRAPPERS[i + 1];
      String E = shortenInt(ET);
      String out = template;
      out = Pattern.compile("#e#").matcher(out).replaceAll(e);
      out = Pattern.compile("#E#").matcher(out).replaceAll(E);
      out = Pattern.compile("#ET#").matcher(out).replaceAll(ET);
      String outFile = pathPrefix + E + pathSuffix;
      writeFile(outFile, out);
    }
  }

  private static void generateP2PMapDecorators() throws IOException {
    String template = readFile(P2P_MAP_DECORATOR_NAME);
    for (int i = 0; i < WRAPPERS.length; i += 2) {
      for (int j = 0; j < WRAPPERS.length; j += 2) {
        String k = WRAPPERS[i];
        String KT = WRAPPERS[i + 1];
        String v = WRAPPERS[j];
        String VT = WRAPPERS[j + 1];
        String K = shortenInt(KT);
        String V = shortenInt(VT);
        String out = template;
        out = Pattern.compile("#v#").matcher(out).replaceAll(v);
        out = Pattern.compile("#V#").matcher(out).replaceAll(V);
        out = Pattern.compile("#k#").matcher(out).replaceAll(k);
        out = Pattern.compile("#K#").matcher(out).replaceAll(K);
        out = Pattern.compile("#KT#").matcher(out).replaceAll(KT);
        out = Pattern.compile("#VT#").matcher(out).replaceAll(VT);
        String outFile = "src/gnu/trove/decorator/T" + K + V + "HashMapDecorator.java";
        writeFile(outFile, out);
      }
    }
  }

  private static void writeFile(String file, String out) throws IOException {
    FileWriter writer = new FileWriter(file);
    writer.write(out);
    writer.close();
    System.out.println("File written: " + file);
  }

  private static String shortenInt(String type) {
    return type.equals("Integer") ? "Int" : type;
  }

  private static String readFile(String name) throws IOException {
    String packageName = Generate.class.getPackage().getName();
    URL resource = Generate.class.getClassLoader().getResource(packageName.replace('.', '/') + "/" + name);
    InputStream inputStream = resource.openConnection().getInputStream();
    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
    StringBuffer out = new StringBuffer();

    while (true) {
      String line = reader.readLine();
      if (line == null) break;
      out.append(line);
      out.append("\n");
    }
    return out.toString();
  }
}
