/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.editors.ListEditorDialog;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ListModelEditor
extends PropertyEditor<String[]> {
    private final TextFieldWithBrowseButton myTextField = new TextFieldWithBrowseButton();
    private RadComponent myLastComponent;
    private String[] myLastValue;
    private final String myPropertyName;

    public ListModelEditor(String propertyName) {
        this.myPropertyName = propertyName;
        this.myTextField.getTextField().setBorder(null);
        this.myTextField.getTextField().setEditable(false);
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListModelEditor.this.openListEditorDialog(ListModelEditor.this.myLastValue);
            }
        });
    }

    private void openListEditorDialog(String[] value) {
        ListEditorDialog dlg = new ListEditorDialog(this.myLastComponent.getProject(), this.myPropertyName);
        dlg.setValue(value);
        dlg.show();
        if (dlg.getExitCode() == 0) {
            this.myLastValue = dlg.getValue();
            this.myTextField.setText(ListModelEditor.listValueToString(this.myLastValue));
            this.fireValueCommitted(true, false);
        }
    }

    @Override
    public String[] getValue() throws Exception {
        return this.myLastValue;
    }

    @Override
    public JComponent getComponent(RadComponent component, String[] value, InplaceContext inplaceContext) {
        this.myLastComponent = component;
        if (inplaceContext != null) {
            if (inplaceContext.isStartedByTyping()) {
                this.openListEditorDialog(new String[]{Character.toString(inplaceContext.getStartChar())});
            } else {
                this.openListEditorDialog(value);
            }
        } else {
            this.myLastValue = value;
            this.myTextField.setText(ListModelEditor.listValueToString(value));
        }
        return this.myTextField;
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }

    public static String listValueToString(String[] value) {
        if (value == null) {
            return "";
        }
        return StringUtil.join((String[])value, (String)", ");
    }
}

