/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.clientProperties;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClientPropertiesManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.clientProperties.ClientPropertiesManager");
    @NonNls
    private static final String ELEMENT_PROPERTIES = "properties";
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String COMPONENT_NAME = "ClientPropertiesManager";
    private static ClientPropertiesManager ourDefaultManager;
    private final Map<String, List<ClientProperty>> myPropertyMap = new TreeMap<String, List<ClientProperty>>();

    public static ClientPropertiesManager getInstance(Project project) {
        return (ClientPropertiesManager)((Object)project.getComponent(ClientPropertiesManager.class));
    }

    public ClientPropertiesManager() {
        super(null);
    }

    private ClientPropertiesManager(Map<String, List<ClientProperty>> propertyMap) {
        this();
        this.myPropertyMap.putAll(propertyMap);
    }

    public ClientPropertiesManager clone() {
        return new ClientPropertiesManager(this.myPropertyMap);
    }

    public void saveFrom(ClientPropertiesManager manager) {
        this.myPropertyMap.clear();
        this.myPropertyMap.putAll(manager.myPropertyMap);
    }

    public void projectOpened() {
        ClientPropertiesManager.checkInitDefaultManager();
    }

    private static void checkInitDefaultManager() {
        if (ourDefaultManager == null) {
            ourDefaultManager = new ClientPropertiesManager();
            try {
                Document document = new SAXBuilder().build(ClientPropertiesManager.class.getResource("/ClientPropertiesManager.xml"));
                Element child = document.getRootElement();
                ourDefaultManager.readExternal(child);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/clientProperties/ClientPropertiesManager.getComponentName must not return null");
        }
        return COMPONENT_NAME;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myPropertyMap.clear();
        for (Object o : element.getChildren(ELEMENT_PROPERTIES)) {
            Element propertiesElement = (Element)o;
            String aClass = propertiesElement.getAttributeValue(ATTRIBUTE_CLASS);
            ArrayList<ClientProperty> classProps = new ArrayList<ClientProperty>();
            for (Object p : propertiesElement.getChildren(ELEMENT_PROPERTY)) {
                Element propertyElement = (Element)p;
                String propName = propertyElement.getAttributeValue(ATTRIBUTE_NAME);
                String propClass = propertyElement.getAttributeValue(ATTRIBUTE_CLASS);
                classProps.add(new ClientProperty(propName, propClass));
            }
            this.myPropertyMap.put(aClass, classProps);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.equals((Object)ourDefaultManager)) {
            throw new WriteExternalException();
        }
        for (Map.Entry<String, List<ClientProperty>> entry : this.myPropertyMap.entrySet()) {
            Element propertiesElement = new Element(ELEMENT_PROPERTIES);
            propertiesElement.setAttribute(ATTRIBUTE_CLASS, entry.getKey());
            for (ClientProperty prop : entry.getValue()) {
                Element propertyElement = new Element(ELEMENT_PROPERTY);
                propertyElement.setAttribute(ATTRIBUTE_NAME, prop.getName());
                propertyElement.setAttribute(ATTRIBUTE_CLASS, prop.getValueClass());
                propertiesElement.addContent(propertyElement);
            }
            element.addContent(propertiesElement);
        }
    }

    public void addConfiguredProperty(Class selectedClass, ClientProperty enteredProperty) {
        List<ClientProperty> list = this.myPropertyMap.get(selectedClass.getName());
        if (list == null) {
            list = new ArrayList<ClientProperty>();
            this.myPropertyMap.put(selectedClass.getName(), list);
        }
        list.add(enteredProperty);
    }

    public void removeConfiguredProperty(Class selectedClass, String name) {
        List<ClientProperty> list = this.myPropertyMap.get(selectedClass.getName());
        if (list != null) {
            for (ClientProperty prop : list) {
                if (!prop.getName().equals(name)) continue;
                list.remove(prop);
                break;
            }
        }
    }

    public List<Class> getConfiguredClasses() {
        ArrayList<Class> result = new ArrayList<Class>();
        for (String className : this.myPropertyMap.keySet()) {
            try {
                result.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {}
        }
        return result;
    }

    public void addClientPropertyClass(String className) {
        if (!this.myPropertyMap.containsKey(className)) {
            this.myPropertyMap.put(className, new ArrayList());
        }
    }

    public void removeClientPropertyClass(Class selectedClass) {
        this.myPropertyMap.remove(selectedClass.getName());
    }

    public ClientProperty[] getConfiguredProperties(Class componentClass) {
        List<ClientProperty> list = this.myPropertyMap.get(componentClass.getName());
        if (list == null) {
            return new ClientProperty[0];
        }
        return list.toArray(new ClientProperty[list.size()]);
    }

    public ClientProperty[] getClientProperties(Class componentClass) {
        ArrayList<ClientProperty> result = new ArrayList<ClientProperty>();
        while (!componentClass.getName().equals(Object.class.getName())) {
            List<ClientProperty> props = this.myPropertyMap.get(componentClass.getName());
            if (props != null) {
                result.addAll(props);
            }
            componentClass = componentClass.getSuperclass();
        }
        Collections.sort(result);
        return result.toArray(new ClientProperty[result.size()]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClientPropertiesManager)) {
            return false;
        }
        ClientPropertiesManager rhs = (ClientPropertiesManager)((Object)obj);
        if (rhs.myPropertyMap.size() != this.myPropertyMap.size()) {
            return false;
        }
        for (Map.Entry<String, List<ClientProperty>> entry : this.myPropertyMap.entrySet()) {
            List<ClientProperty> rhsList = rhs.myPropertyMap.get(entry.getKey());
            if (rhsList == null || rhsList.size() != entry.getValue().size()) {
                return false;
            }
            for (ClientProperty prop : entry.getValue()) {
                if (rhsList.contains(prop)) continue;
                return false;
            }
        }
        return true;
    }

    public static class ClientProperty
    implements Comparable {
        private final String myName;
        private final String myClass;

        public ClientProperty(String name, String aClass) {
            this.myName = name;
            this.myClass = aClass;
        }

        public String getName() {
            return this.myName;
        }

        public String getValueClass() {
            return this.myClass;
        }

        public int compareTo(Object o) {
            ClientProperty prop = (ClientProperty)o;
            return this.myName.compareTo(prop.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientProperty that = (ClientProperty)o;
            if (!this.myClass.equals(that.myClass)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myClass.hashCode();
            return result;
        }
    }
}

