/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.SelectFromMavenProjectsDialog;

public class SelectMavenGoalDialog
extends SelectFromMavenProjectsDialog {
    private String myProjectPath;
    private String myGoal;

    public SelectMavenGoalDialog(Project project, final String projectPath, final String goal, String title) {
        super(project, title, MavenProjectsStructure.GoalNode.class, new SelectFromMavenProjectsDialog.NodeSelector(){

            @Override
            public boolean shouldSelect(SimpleNode node) {
                if (node instanceof MavenProjectsStructure.GoalNode) {
                    MavenProjectsStructure.GoalNode goalNode = (MavenProjectsStructure.GoalNode)node;
                    return FileUtil.pathsEqual((String)goalNode.getProjectPath(), (String)projectPath) && goalNode.getGoal().equals(goal);
                }
                return false;
            }
        });
        this.myProjectPath = projectPath;
        this.myGoal = goal;
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        SimpleNode node = this.getSelectedNode();
        if (node instanceof MavenProjectsStructure.GoalNode) {
            MavenProjectsStructure.GoalNode goalNode = (MavenProjectsStructure.GoalNode)node;
            this.myProjectPath = goalNode.getProjectPath();
            this.myGoal = goalNode.getGoal();
        }
    }

    public String getSelectedProjectPath() {
        return this.myProjectPath;
    }

    public String getSelectedGoal() {
        return this.myGoal;
    }
}

