/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XmlTagNamesIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlExtension
extends XmlExtension {
    @Override
    public boolean isAvailable(PsiFile file) {
        return true;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getAvailableTagNames(@NotNull XmlFile file, @NotNull XmlTag context) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.getAvailableTagNames must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.getAvailableTagNames must not be null");
        }
        HashSet<String> namespaces = new HashSet<String>(Arrays.asList(context.knownNamespaces()));
        XmlSchemaProvider provider = XmlSchemaProvider.getAvailableProvider((XmlFile)file);
        if (provider != null) {
            namespaces.addAll(provider.getAvailableNamespaces(file, null));
        }
        ArrayList<String> nsInfo = new ArrayList<String>();
        String[] names = TagNameReference.getTagNameVariants(context, namespaces, nsInfo);
        ArrayList<Pair<String, String>> set = new ArrayList<Pair<String, String>>(names.length);
        Iterator<String> iterator = nsInfo.iterator();
        for (String name : names) {
            int pos = name.indexOf(58);
            String s = pos >= 0 ? name.substring(pos + 1) : name;
            set.add((Pair<String, String>)Pair.create((Object)s, (Object)iterator.next()));
        }
        ArrayList<Pair<String, String>> arrayList = set;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/DefaultXmlExtension.getAvailableTagNames must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile context) {
        Set set;
        if (tagName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.getNamespacesByTagName must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.getNamespacesByTagName must not be null");
        }
        XmlSchemaProvider provider = XmlSchemaProvider.getAvailableProvider((XmlFile)context);
        if (provider == null) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/xml/DefaultXmlExtension.getNamespacesByTagName must not return null");
            return set;
        }
        set = provider.getAvailableNamespaces(context, tagName);
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/xml/DefaultXmlExtension.getNamespacesByTagName must not return null");
    }

    public static Set<String> filterNamespaces(Set<String> namespaces, String tagName, XmlFile context) {
        if (tagName == null) {
            return namespaces;
        }
        HashSet<String> set = new HashSet<String>();
        block0: for (String namespace : namespaces) {
            XmlElementDescriptor[] elementDescriptors;
            XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)context, namespace);
            if (xmlFile == null) continue;
            XmlDocument document = xmlFile.getDocument();
            assert (document != null);
            XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
            assert (nsDescriptor != null);
            for (XmlElementDescriptor elementDescriptor : elementDescriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                if (!DefaultXmlExtension.hasTag(elementDescriptor, tagName, new HashSet<XmlElementDescriptor>())) continue;
                set.add(namespace);
                continue block0;
            }
        }
        return set;
    }

    private static boolean hasTag(XmlElementDescriptor elementDescriptor, String tagName, Set<XmlElementDescriptor> visited) {
        String name = elementDescriptor.getDefaultName();
        if (name.equals(tagName)) {
            return true;
        }
        for (XmlElementDescriptor descriptor : elementDescriptor.getElementsDescriptors(null)) {
            if (visited.contains(elementDescriptor)) continue;
            visited.add(elementDescriptor);
            if (!DefaultXmlExtension.hasTag(descriptor, tagName, visited)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element, @NotNull XmlFile file) {
        block10: {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.guessUnboundNamespaces must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.guessUnboundNamespaces must not be null");
            }
            if (!(element instanceof XmlTag)) {
                v0 = Collections.emptySet();
                if (v0 == null) lbl-1000:
                // 3 sources

                {
                    throw new IllegalStateException("@NotNull method com/intellij/xml/DefaultXmlExtension.guessUnboundNamespaces must not return null");
                }
                return v0;
            }
            tag = (XmlTag)element;
            name = tag.getLocalName();
            byTagName = this.getNamespacesByTagName(name, file);
            if (byTagName.isEmpty()) break block10;
            filtered = new HashSet<String>(byTagName);
            filtered.removeAll(Arrays.asList(tag.knownNamespaces()));
            v0 = filtered;
            if (v0 == null) ** GOTO lbl-1000
            return v0;
        }
        set = DefaultXmlExtension.guessNamespace((PsiFile)file, name);
        set.removeAll(Arrays.asList(tag.knownNamespaces()));
        parentTag = tag.getParentTag();
        i = set.iterator();
        block1: while (i.hasNext()) {
            s = i.next();
            namespaces = XmlUtil.findNSFilesByURI(s, element.getProject(), ModuleUtil.findModuleForPsiElement((PsiElement)file));
            for (XmlFile namespace : namespaces) {
                document = namespace.getDocument();
                if (!DefaultXmlExtension.$assertionsDisabled && document == null) {
                    throw new AssertionError();
                }
                nsDescriptor = (XmlNSDescriptor)document.getMetaData();
                if (!DefaultXmlExtension.$assertionsDisabled && nsDescriptor == null) {
                    throw new AssertionError();
                }
                if (parentTag != null) continue block1;
                for (XmlElementDescriptor descriptor : descriptors = nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor.getName().equals(name)) continue block1;
                }
            }
            i.remove();
        }
        v0 = set;
        if (v0 != null) ** break;
        ** while (true)
        return v0;
    }

    @Override
    public void insertNamespaceDeclaration(@NotNull XmlFile file, @NotNull Editor editor, @NotNull Set<String> possibleNamespaces, @Nullable String nsPrefix, @Nullable XmlExtension.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        Set strings;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.insertNamespaceDeclaration must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.insertNamespaceDeclaration must not be null");
        }
        if (possibleNamespaces == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xml/DefaultXmlExtension.insertNamespaceDeclaration must not be null");
        }
        String namespace = possibleNamespaces.iterator().next();
        Project project = file.getProject();
        XmlDocument document = file.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute anchor = null;
        for (XmlAttribute attribute : attributes) {
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (!attribute.isNamespaceDeclaration() && (descriptor == null || !descriptor.isRequired())) break;
            anchor = attribute;
        }
        XmlSchemaProvider provider = XmlSchemaProvider.getAvailableProvider((XmlFile)file);
        String prefix = nsPrefix;
        if (prefix == null && provider != null) {
            prefix = provider.getDefaultPrefix(namespace, file);
        }
        if (prefix == null) {
            prefix = "";
        }
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        String qname = "xmlns" + (prefix.length() > 0 ? ":" + prefix : "");
        XmlAttribute attribute = elementFactory.createXmlAttribute(qname, namespace);
        if (anchor == null) {
            rootTag.add((PsiElement)attribute);
        } else {
            rootTag.addAfter((PsiElement)attribute, (PsiElement)anchor);
        }
        String location = null;
        if (namespace.length() > 0 && provider != null && (strings = provider.getLocations(namespace, file)) != null && strings.size() > 0) {
            location = (String)strings.iterator().next();
        }
        if (location != null) {
            xmlAttribute = rootTag.getAttribute("xsi:schemaLocation");
            String pair = namespace + " " + location;
            if (xmlAttribute == null) {
                xmlAttribute = elementFactory.createXmlAttribute("xsi:schemaLocation", pair);
                rootTag.add((PsiElement)xmlAttribute);
            } else {
                String value = xmlAttribute.getValue();
                if (!value.contains(namespace)) {
                    if (StringUtil.isEmptyOrSpaces((String)value)) {
                        xmlAttribute.setValue(pair);
                    } else {
                        xmlAttribute.setValue(value.trim() + " " + pair);
                    }
                }
            }
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)rootTag);
        if (namespace.length() == 0 && (xmlAttribute = rootTag.getAttribute(qname)) != null) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            assert (value != null);
            int startOffset = value.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
        }
        if (runAfter != null) {
            runAfter.run(prefix);
        }
    }

    @Override
    public boolean isPrefixDeclared(XmlTag context, String namespacePrefix) {
        String nsDeclarationAttrName = null;
        for (XmlTag t = context; t != null; t = t.getParentTag()) {
            if (!t.hasNamespaceDeclarations()) continue;
            if (nsDeclarationAttrName == null) {
                String string = nsDeclarationAttrName = namespacePrefix.length() > 0 ? "xmlns:" + namespacePrefix : "xmlns";
            }
            if (t.getAttributeValue(nsDeclarationAttrName) == null) continue;
            return true;
        }
        return false;
    }

    private static Set<String> guessNamespace(PsiFile file, String tagName) {
        Project project = file.getProject();
        Collection<VirtualFile> files = XmlTagNamesIndex.getFilesByTagName(tagName, project);
        LinkedHashSet<String> possibleUris = new LinkedHashSet<String>(files.size());
        for (VirtualFile virtualFile : files) {
            String namespace = XmlNamespaceIndex.getNamespace(virtualFile, project);
            if (namespace == null) continue;
            possibleUris.add(namespace);
        }
        return possibleUris;
    }
}

