/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.ID;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class IndexInfrastructure {
    private static final int VERSION = 8;
    private static final TObjectLongHashMap<ID<?, ?>> ourIndexIdToCreationStamp = new TObjectLongHashMap();
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();

    private IndexInfrastructure() {
    }

    public static File getVersionFile(ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + ".ver");
    }

    public static File getStorageFile(ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.toString());
    }

    public static File getInputIndexStorageFile(ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.toString() + "_inputs");
    }

    public static File getIndexRootDir(ID<?, ?> indexName) {
        String dirName = indexName.toString().toLowerCase(Locale.US);
        File indexDir = indexName instanceof StubIndexKey ? new File(IndexInfrastructure.getIndexRootDir(StubUpdatingIndex.INDEX_ID), dirName) : new File(PathManager.getIndexRoot(), dirName);
        indexDir.mkdirs();
        return indexDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rewriteVersion(File file, int version) throws IOException {
        long prevLastModifiedValue = file.lastModified();
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        file.getParentFile().mkdirs();
        DataOutputStream os = new DataOutputStream(new FileOutputStream(file));
        try {
            os.writeInt(version);
            os.writeInt(8);
        }
        finally {
            ourIndexIdToCreationStamp.clear();
            os.close();
            file.setLastModified(Math.max(System.currentTimeMillis(), prevLastModifiedValue + 1000L));
        }
    }

    public static long getIndexCreationStamp(ID<?, ?> indexName) {
        long stamp = ourIndexIdToCreationStamp.get(indexName);
        if (stamp <= 0L) {
            stamp = IndexInfrastructure.getVersionFile(indexName).lastModified();
            ourIndexIdToCreationStamp.put(indexName, stamp);
        }
        return stamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean versionDiffers(File versionFile, int currentIndexVersion) {
        boolean bl;
        DataInputStream in = new DataInputStream(new FileInputStream(versionFile));
        try {
            int savedIndexVersion = in.readInt();
            int commonVersion = in.readInt();
            bl = savedIndexVersion != currentIndexVersion || commonVersion != 8;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        in.close();
        return bl;
    }

    @Nullable
    public static VirtualFile findFileById(PersistentFS fs, int id) {
        VirtualFile testFile;
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileById(id);
    }

    @Nullable
    private static VirtualFile findTestFile(int id) {
        return DummyFileSystem.getInstance().findById(id);
    }
}

