/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsUnit;
import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ScrambledInputStream;
import com.intellij.util.ScrambledOutputStream;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsManagerImpl
extends StatisticsManager {
    private static final int UNIT_COUNT = 997;
    private static final Object LOCK = new Object();
    @NonNls
    private static final String STORE_PATH = PathManager.getSystemPath() + File.separator + "stat";
    private final SoftReference[] myUnits = new SoftReference[997];
    private final HashSet<StatisticsUnit> myModifiedUnits = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUseCount(@NotNull StatisticsInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/statistics/impl/StatisticsManagerImpl.getUseCount must not be null");
        }
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImpl.getUnitNumber(key1);
        Object object = LOCK;
        synchronized (object) {
            StatisticsUnit unit = this.getUnit(unitNumber);
            return unit.getData(key1, info.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incUseCount(@NotNull StatisticsInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/statistics/impl/StatisticsManagerImpl.incUseCount must not be null");
        }
        if (info == StatisticsInfo.EMPTY) {
            return;
        }
        String key1 = info.getContext();
        int unitNumber = StatisticsManagerImpl.getUnitNumber(key1);
        Object object = LOCK;
        synchronized (object) {
            StatisticsUnit unit = this.getUnit(unitNumber);
            unit.incData(key1, info.getValue());
            this.myModifiedUnits.add(unit);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticsInfo[] getAllValues(final String context) {
        Object[] strings;
        Object object = LOCK;
        synchronized (object) {
            strings = this.getUnit(StatisticsManagerImpl.getUnitNumber(context)).getKeys2(context);
        }
        return (StatisticsInfo[])ContainerUtil.map2Array((Object[])strings, StatisticsInfo.class, (Function)new NotNullFunction<String, StatisticsInfo>(){

            @NotNull
            public StatisticsInfo fun(String s) {
                StatisticsInfo statisticsInfo = new StatisticsInfo(context, s);
                if (statisticsInfo == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/statistics/impl/StatisticsManagerImpl$1.fun must not return null");
                }
                return statisticsInfo;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = LOCK;
        synchronized (object) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                for (StatisticsUnit unit : this.myModifiedUnits) {
                    this.saveUnit(unit.getNumber());
                }
            }
            this.myModifiedUnits.clear();
        }
    }

    private StatisticsUnit getUnit(int unitNumber) {
        StatisticsUnit unit;
        SoftReference ref = this.myUnits[unitNumber];
        if (ref != null && (unit = (StatisticsUnit)ref.get()) != null) {
            return unit;
        }
        unit = StatisticsManagerImpl.loadUnit(unitNumber);
        if (unit == null) {
            unit = new StatisticsUnit(unitNumber);
        }
        this.myUnits[unitNumber] = new SoftReference((Object)unit);
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatisticsUnit loadUnit(int unitNumber) {
        StatisticsUnit unit = new StatisticsUnit(unitNumber);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String path = StatisticsManagerImpl.getPathToUnit(unitNumber);
            try {
                InputStream in = new BufferedInputStream(new FileInputStream(path));
                in = new ScrambledInputStream(in);
                try {
                    unit.read(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
            }
            catch (WrongFormatException wrongFormatException) {
                // empty catch block
            }
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUnit(int unitNumber) {
        if (!StatisticsManagerImpl.createStoreFolder()) {
            return;
        }
        StatisticsUnit unit = this.getUnit(unitNumber);
        String path = StatisticsManagerImpl.getPathToUnit(unitNumber);
        try {
            OutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            out = new ScrambledOutputStream(out);
            try {
                unit.write(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistics", (Object[])new Object[]{e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    private static int getUnitNumber(String key1) {
        return Math.abs(key1.hashCode()) % 997;
    }

    private static boolean createStoreFolder() {
        File homeFile = new File(STORE_PATH);
        if (!homeFile.exists() && !homeFile.mkdirs()) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistic.failed.to.create.folder", (Object[])new Object[]{STORE_PATH}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    private static String getPathToUnit(int unitNumber) {
        return STORE_PATH + File.separator + "unit." + unitNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatistics() {
        Object object = LOCK;
        synchronized (object) {
            Arrays.fill(this.myUnits, null);
        }
    }
}

