/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatInfoPrinter;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.Helper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jdom.Element;

public class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade");
    private final CodeStyleSettings mySettings;
    private final Helper myHelper;

    public CodeFormatterFacade(CodeStyleSettings settings, Helper helper) {
        this.mySettings = settings;
        this.myHelper = helper;
    }

    public ASTNode process(ASTNode element, int parent_indent) {
        PsiFile file = SourceTreeToPsiMap.treeElementToPsi(element).getContainingFile();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder != null) {
            TextRange range = element.getTextRange();
            return this.processRange(element, range.getStartOffset(), range.getEndOffset());
        }
        return element;
    }

    public ASTNode processRange(ASTNode element, int startOffset, int endOffset) {
        RangeMarker rangeMarker;
        FileType fileType = this.myHelper.getFileType();
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        PsiFile file = SourceTreeToPsiMap.treeElementToPsi(element).getContainingFile();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        Document document = file.getViewProvider().getDocument();
        RangeMarker rangeMarker2 = rangeMarker = document != null && endOffset < document.getTextLength() ? document.createRangeMarker(startOffset, endOffset) : null;
        if (builder != null) {
            TextRange range = CodeFormatterFacade.preprocess(element, startOffset, endOffset);
            PsiFile containingFile = psiElement.getContainingFile();
            FormattingModel model = builder.createModel(psiElement, this.mySettings);
            if (containingFile.getTextLength() > 0) {
                try {
                    FormatterEx.getInstanceEx().format(model, this.mySettings, this.mySettings.getIndentOptions(fileType), new FormatTextRanges(range, true));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (!psiElement.isValid()) {
                if (rangeMarker != null) {
                    PsiElement at = file.findElementAt(rangeMarker.getStartOffset());
                    PsiElement result = PsiTreeUtil.getParentOfType((PsiElement)at, psiElement.getClass(), (boolean)false);
                    assert (result != null);
                    return result.getNode();
                }
                assert (false);
            }
        }
        return element;
    }

    public void processTextWithPostponedFormatting(PsiFile file, FormatTextRanges ranges) {
        FileType fileType = this.myHelper.getFileType();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder != null && file.getTextLength() > 0) {
            try {
                ranges.preprocess(file.getNode());
                Project project = file.getProject();
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                RangeMarker[] markers = new RangeMarker[ranges.getRanges().size()];
                int i = 0;
                for (FormatTextRanges.FormatTextRange range : ranges.getRanges()) {
                    TextRange textRange = range.getTextRange();
                    int start = textRange.getStartOffset();
                    int end = textRange.getEndOffset();
                    if (start < 0 || end <= start || end > document.getTextLength()) continue;
                    markers[i] = document.createRangeMarker(textRange);
                    markers[i].setGreedyToLeft(true);
                    markers[i].setGreedyToRight(true);
                    ++i;
                }
                PostprocessReformattingAspect component = (PostprocessReformattingAspect)file.getProject().getComponent(PostprocessReformattingAspect.class);
                component.doPostponedFormatting(file.getViewProvider());
                i = 0;
                for (FormatTextRanges.FormatTextRange range : ranges.getRanges()) {
                    if (markers[i] != null) {
                        range.setTextRange(new TextRange(markers[i].getStartOffset(), markers[i].getEndOffset()));
                    }
                    ++i;
                }
                Block rootBlock = builder.createModel((PsiElement)file, this.mySettings).getRootBlock();
                DocumentBasedFormattingModel model = new DocumentBasedFormattingModel(rootBlock, document, project, this.mySettings, fileType, file);
                FormatterEx.getInstanceEx().format(model, this.mySettings, this.mySettings.getIndentOptions(fileType), ranges);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void printToConsole(Block rootBlock, FormattingModel model) {
        String tree = JDOMUtil.writeElement((Element)new FormatInfoPrinter(rootBlock, model.getDocumentModel()).blocksAsTree(), (String)"\n");
        System.out.println("---TREE---");
        System.out.println(tree);
        System.out.println("---/TREE---");
    }

    public void processText(PsiFile file, FormatTextRanges ranges) {
        FileType fileType = this.myHelper.getFileType();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder != null && file.getTextLength() > 0) {
            try {
                ranges.preprocess(file.getNode());
                FormattingModel originalModel = builder.createModel((PsiElement)file, this.mySettings);
                Project project = file.getProject();
                DocumentBasedFormattingModel model = new DocumentBasedFormattingModel(originalModel.getRootBlock(), PsiDocumentManager.getInstance((Project)project).getDocument(file), project, this.mySettings, fileType, file);
                FormatterEx.getInstanceEx().format(model, this.mySettings, this.mySettings.getIndentOptions(fileType), ranges);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static TextRange preprocess(ASTNode node, int startOffset, int endOffset) {
        TextRange result = new TextRange(startOffset, endOffset);
        for (PreFormatProcessor processor : (PreFormatProcessor[])Extensions.getExtensions(PreFormatProcessor.EP_NAME)) {
            result = processor.process(node, result);
        }
        return result;
    }
}

