/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.util.ReflectionCache;
import org.jetbrains.annotations.NonNls;

public class ClassFilter
implements ElementFilter {
    private final Class myFilter;
    private final boolean myAcceptableFlag;

    public ClassFilter(Class filter) {
        this(filter, true);
    }

    public ClassFilter(Class filter, boolean acceptableFlag) {
        this.myFilter = filter;
        this.myAcceptableFlag = acceptableFlag;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return this.myAcceptableFlag ? this.filterMatches(hintClass) : !this.filterMatches(hintClass);
    }

    private boolean filterMatches(Class hintClass) {
        return ReflectionCache.isAssignable((Class)this.myFilter, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element == null) {
            return false;
        }
        return this.myAcceptableFlag ? this.filterMatches(element.getClass()) : !this.filterMatches(element.getClass());
    }

    @NonNls
    public String toString() {
        return "class(" + this.myFilter.getName() + ")";
    }
}

