/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDataImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyFileSystem
extends DeprecatedVirtualFileSystem
implements ApplicationComponent {
    @NonNls
    public static final String PROTOCOL = "dummy";
    private VirtualFileDirectoryImpl myRoot;

    public static DummyFileSystem getInstance() {
        return (DummyFileSystem)((Object)ApplicationManager.getApplication().getComponent(DummyFileSystem.class));
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public VirtualFile createRoot(String name) {
        this.myRoot = new VirtualFileDirectoryImpl(this, null, name);
        this.fireFileCreated(null, (VirtualFile)this.myRoot);
        return this.myRoot;
    }

    @Nullable
    public VirtualFile findById(int id) {
        return DummyFileSystem.findById(id, this.myRoot);
    }

    @Nullable
    private static VirtualFile findById(int id, VirtualFileImpl r) {
        if (r == null) {
            return null;
        }
        if (r.getId() == id) {
            return r;
        }
        VirtualFile[] children = r.getChildren();
        if (children != null) {
            for (VirtualFile f : children) {
                VirtualFile child = DummyFileSystem.findById(id, (VirtualFileImpl)f);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.getProtocol must not return null");
        }
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.findFileByPath must not be null");
        }
        return null;
    }

    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.extractPresentableUrl must not be null");
        }
        return path;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.refreshAndFindFileByPath must not be null");
        }
        return this.findFileByPath(path);
    }

    @NotNull
    public String getComponentName() {
        if ("DummyFileSystem" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.getComponentName must not return null");
        }
        return "DummyFileSystem";
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.deleteFile must not be null");
        }
        this.fireBeforeFileDeletion(requestor, vFile);
        VirtualFileDirectoryImpl parent = (VirtualFileDirectoryImpl)vFile.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"file.delete.root.error", (Object[])new Object[]{vFile.getPresentableUrl()}));
        }
        parent.removeChild((VirtualFileImpl)vFile);
        this.fireFileDeleted(requestor, vFile, vFile.getName(), (VirtualFile)parent);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.moveFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.copyFile must not be null");
        }
        throw new UnsupportedOperationException();
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.renameFile must not be null");
        }
        String oldName = vFile.getName();
        this.fireBeforePropertyChange(requestor, vFile, "name", oldName, newName);
        ((VirtualFileImpl)vFile).setName(newName);
        this.firePropertyChanged(requestor, vFile, "name", oldName, newName);
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.createChildFile must not be null");
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDataImpl child = new VirtualFileDataImpl(this, dir, fileName);
        dir.addChild(child);
        this.fireFileCreated(requestor, (VirtualFile)child);
        return child;
    }

    public void fireBeforeContentsChange(Object requestor, VirtualFile file) {
        super.fireBeforeContentsChange(requestor, file);
    }

    public void fireContentsChanged(Object requestor, VirtualFile file, long oldModificationStamp) {
        super.fireContentsChanged(requestor, file, oldModificationStamp);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.createChildDirectory must not be null");
        }
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDirectoryImpl child = new VirtualFileDirectoryImpl(this, dir, dirName);
        dir.addChild(child);
        this.fireFileCreated(requestor, (VirtualFile)child);
        VirtualFileDirectoryImpl virtualFileDirectoryImpl = child;
        if (virtualFileDirectoryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/dummy/DummyFileSystem.createChildDirectory must not return null");
        }
        return virtualFileDirectoryImpl;
    }
}

