/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingTo;
import com.intellij.openapi.vfs.encoding.ChooseEncodingDialog;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeFileEncodingGroup
extends ActionGroup {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/ChangeFileEncodingGroup.getChildren must not return null");
            return anActionArray;
        }
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        Collection charsets = EncodingManager.getInstance().getFavorites();
        ArrayList<Object> children = new ArrayList<Object>();
        for (Charset charset : charsets) {
            ChangeFileEncodingTo action = new ChangeFileEncodingTo(virtualFile, charset);
            children.add(action);
        }
        children.add((Object)new More(virtualFile));
        children.add(new Separator());
        anActionArray = children.toArray(new AnAction[children.size()]);
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/encoding/ChangeFileEncodingGroup.getChildren must not return null");
    }

    private static class More
    extends AnAction
    implements DumbAware {
        private final VirtualFile myVirtualFile;

        private More(VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
            this.getTemplatePresentation().setText("more...");
        }

        public void actionPerformed(AnActionEvent e) {
            Charset[] charsets = CharsetToolkit.getAvailableCharsets();
            ChooseEncodingDialog dialog = new ChooseEncodingDialog(charsets, this.myVirtualFile.getCharset(), this.myVirtualFile);
            dialog.show();
            Charset charset = dialog.getChosen();
            if (dialog.isOK() && charset != null) {
                EncodingManager.getInstance().setEncoding(this.myVirtualFile, charset);
            }
        }
    }
}

