/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Icons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileTreeNode
extends FileOrDirectoryTreeNode {
    private static final Collection<VirtualFile> EMPTY_VIRTUAL_FILE_ARRAY = new ArrayList<VirtualFile>();

    public FileTreeNode(@NotNull String path, SimpleTextAttributes invalidAttributes, Project project, String parentPath) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/FileTreeNode.<init> must not be null");
        }
        super(path, invalidAttributes, project, parentPath);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myFile.isDirectory()) {
            return Icons.DIRECTORY_CLOSED_ICON;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon();
    }

    @Override
    public Collection<VirtualFile> getVirtualFiles() {
        VirtualFile virtualFile = this.getFilePointer().getFile();
        if (virtualFile == null) {
            return EMPTY_VIRTUAL_FILE_ARRAY;
        }
        return Collections.singleton(virtualFile);
    }

    @Override
    public Collection<File> getFiles() {
        if (this.getFilePointer().getFile() == null) {
            return Collections.singleton(this.myFile);
        }
        return EMPTY_FILE_ARRAY;
    }

    @Override
    protected int getItemsCount() {
        return 1;
    }

    @Override
    protected boolean showStatistics() {
        return false;
    }
}

