/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.ShowHideColorsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.HighlightAnnotationsActions;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateToggleAction
extends ToggleAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.actions.AnnotateToggleAction");
    protected static final Key<Collection<ActiveAnnotationGutter>> KEY_IN_EDITOR = Key.create((String)"Annotations");
    private static final Color[] BG_COLORS = new Color[]{new Color(222, 241, 229), new Color(234, 255, 226), new Color(208, 229, 229), new Color(255, 226, 199), new Color(227, 226, 223), new Color(255, 213, 203), new Color(220, 204, 236), new Color(255, 191, 195), new Color(243, 223, 243), new Color(217, 228, 249), new Color(255, 251, 207), new Color(217, 222, 229), new Color(255, 204, 238), new Color(236, 236, 236)};

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(AnnotateToggleAction.isEnabled(VcsContextFactory.SERVICE.getInstance().createContextOn(e)));
    }

    private static boolean isEnabled(VcsContext context) {
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        if (selectedFiles == null) {
            return false;
        }
        if (selectedFiles.length != 1) {
            return false;
        }
        VirtualFile file = selectedFiles[0];
        if (file.isDirectory()) {
            return false;
        }
        Project project = context.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        BackgroundableActionEnabledHandler handler = ((ProjectLevelVcsManagerImpl)plVcsManager).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE);
        if (handler.isInProgress(file.getPath())) {
            return false;
        }
        AbstractVcs vcs = plVcsManager.getVcsFor(file);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED) {
            return false;
        }
        return AnnotateToggleAction.hasTextEditor(file);
    }

    private static boolean hasTextEditor(VirtualFile selectedFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = fileTypeManager.getFileTypeByFile(selectedFile);
        return !fileType.isBinary() && fileType != StdFileTypes.GUI_DESIGNER_FORM;
    }

    public boolean isSelected(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Editor editor = context.getEditor();
        if (editor == null) {
            return false;
        }
        Collection annotations = (Collection)editor.getUserData(KEY_IN_EDITOR);
        return annotations != null && !annotations.isEmpty();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Editor editor = context.getEditor();
        if (!state) {
            if (editor != null) {
                editor.getGutter().closeAllAnnotations();
            }
        } else {
            if (editor == null) {
                FileEditor[] fileEditors;
                VirtualFile selectedFile = context.getSelectedFile();
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)context.getProject()).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
            }
            LOG.assertTrue(editor != null);
            AnnotateToggleAction.doAnnotate(editor, context.getProject());
        }
    }

    private static void doAnnotate(final Editor editor, final Project project) {
        final VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (project == null) {
            return;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs vcs = plVcsManager.getVcsFor(file);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionEnabledHandler handler = ((ProjectLevelVcsManagerImpl)plVcsManager).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE);
        handler.register(file.getPath());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/actions/AnnotateToggleAction$1.run must not be null");
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                handler.completed(file.getPath());
                if (!exceptionRef.isNull()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Arrays.asList((VcsException)((Object)exceptionRef.get())), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (fileAnnotationRef.isNull()) {
                    return;
                }
                AnnotateToggleAction.doAnnotate(editor, project, file, (FileAnnotation)fileAnnotationRef.get());
            }
        });
    }

    public static void doAnnotate(Editor editor, Project project, VirtualFile file, FileAnnotation fileAnnotation) {
        LineAnnotationAspect[] aspects;
        String upToDateContent = fileAnnotation.getAnnotatedContent();
        UpToDateLineNumberProviderImpl getUpToDateLineNumber = new UpToDateLineNumberProviderImpl(editor.getDocument(), project, upToDateContent);
        editor.getGutter().closeAllAnnotations();
        HashSet<AnnotationFieldGutter> annotations = (HashSet<AnnotationFieldGutter>)editor.getUserData(KEY_IN_EDITOR);
        if (annotations == null) {
            annotations = new HashSet<AnnotationFieldGutter>();
            editor.putUserData(KEY_IN_EDITOR, annotations);
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editor.getGutter();
        HighlightAnnotationsActions highlighting = new HighlightAnnotationsActions(project, file, fileAnnotation, editorGutterComponentEx);
        ArrayList<AnnotationFieldGutter> gutters = new ArrayList<AnnotationFieldGutter>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        MyAnnotationPresentation presentation = new MyAnnotationPresentation(highlighting, switcher, editorGutterComponentEx, gutters);
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisonAspect = switcher.getRevisionAspect();
            MyCurrentRevisionAnnotationFieldGutter currentRevisionGutter = new MyCurrentRevisionAnnotationFieldGutter(fileAnnotation, editor, revisonAspect, presentation);
            MyMergeSourceAvailableMarkerGutter mergeSourceGutter = new MyMergeSourceAvailableMarkerGutter(fileAnnotation, editor, null, presentation);
            presentation.addSourceSwitchListener(currentRevisionGutter);
            presentation.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.consume(switcher.getDefaultSource());
            mergeSourceGutter.consume(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        Map<String, Color> revNumbers = Registry.is((String)"vcs.show.colored.annotations") ? AnnotateToggleAction.computeBgColors(fileAnnotation) : null;
        for (LineAnnotationAspect aspect : aspects = fileAnnotation.getAspects()) {
            AnnotationFieldGutter gutter = new AnnotationFieldGutter(fileAnnotation, editor, aspect, presentation);
            gutters.add(gutter);
            gutter.setAspectValueToBgColorMap(revNumbers);
        }
        gutters.add(new MyHighlightedAdditionalColumn(fileAnnotation, editor, null, presentation, highlighting));
        for (AnnotationFieldGutter gutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy = new AnnotationGutterLineConvertorProxy(getUpToDateLineNumber, gutter);
            if (gutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
            } else {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
            }
            annotations.add(gutter);
        }
    }

    @Nullable
    private static Map<String, Color> computeBgColors(FileAnnotation fileAnnotation) {
        HashMap<String, Color> bgColors = new HashMap<String, Color>();
        HashMap<String, Color> revNumbers = new HashMap<String, Color>();
        int length = BG_COLORS.length;
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            for (VcsFileRevision revision : fileRevisionList) {
                String author = revision.getAuthor();
                String revNumber = revision.getRevisionNumber().asString();
                if (author != null && !bgColors.containsKey(author)) {
                    int size = bgColors.size();
                    bgColors.put(author, BG_COLORS[size < length ? size : size % length]);
                }
                if (revNumbers.containsKey(revNumber)) continue;
                revNumbers.put(revNumber, (Color)bgColors.get(author));
            }
        }
        return bgColors.size() < 2 ? null : revNumbers;
    }

    private static class MySwitchAnnotationSourceAction
    extends AnAction {
        private static final String ourShowMerged = VcsBundle.message((String)"annotation.switch.to.merged.text", (Object[])new Object[0]);
        private static final String ourHideMerged = VcsBundle.message((String)"annotation.switch.to.original.text", (Object[])new Object[0]);
        private final AnnotationSourceSwitcher mySwitcher;
        private final EditorGutterComponentEx myGutter;
        private final List<Consumer<AnnotationSource>> myListeners;
        private boolean myShowMerged;

        private MySwitchAnnotationSourceAction(AnnotationSourceSwitcher switcher, EditorGutterComponentEx gutter) {
            this.mySwitcher = switcher;
            this.myGutter = gutter;
            this.myListeners = new ArrayList<Consumer<AnnotationSource>>();
            this.myShowMerged = this.mySwitcher.getDefaultSource().showMerged();
        }

        public void addSourceSwitchListener(Consumer<AnnotationSource> listener) {
            this.myListeners.add(listener);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setText(this.myShowMerged ? ourHideMerged : ourShowMerged);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myShowMerged = !this.myShowMerged;
            AnnotationSource newSource = AnnotationSource.getInstance((boolean)this.myShowMerged);
            this.mySwitcher.switchTo(newSource);
            for (Consumer<AnnotationSource> listener : this.myListeners) {
                listener.consume((Object)newSource);
            }
            this.myGutter.revalidateMarkup();
        }
    }

    private static class MyAnnotationPresentation
    implements TextAnnotationPresentation {
        private final HighlightAnnotationsActions myHighlighting;
        @Nullable
        private final AnnotationSourceSwitcher mySwitcher;
        private final List<AnnotationFieldGutter> myGutters;
        private final List<AnAction> myActions;
        private MySwitchAnnotationSourceAction mySwitchAction;

        public MyAnnotationPresentation(@NotNull HighlightAnnotationsActions highlighting, @Nullable AnnotationSourceSwitcher switcher, EditorGutterComponentEx gutter, List<AnnotationFieldGutter> gutters) {
            if (highlighting == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/actions/AnnotateToggleAction$MyAnnotationPresentation.<init> must not be null");
            }
            this.myHighlighting = highlighting;
            this.mySwitcher = switcher;
            this.myGutters = gutters;
            this.myActions = new ArrayList<AnAction>(this.myHighlighting.getList());
            if (this.mySwitcher != null) {
                this.mySwitchAction = new MySwitchAnnotationSourceAction(this.mySwitcher, gutter);
                this.myActions.add(this.mySwitchAction);
            }
            this.myActions.add(new ShowHideColorsAction(this.myGutters, gutter));
        }

        @Override
        public EditorFontType getFontType(int line) {
            return this.myHighlighting.isLineBold(line) ? EditorFontType.BOLD : EditorFontType.PLAIN;
        }

        @Override
        public ColorKey getColor(int line) {
            if (this.mySwitcher == null) {
                return AnnotationSource.LOCAL.getColor();
            }
            return this.mySwitcher.getAnnotationSource(line).getColor();
        }

        @Override
        public List<AnAction> getActions() {
            return this.myActions;
        }

        public void addSourceSwitchListener(Consumer<AnnotationSource> listener) {
            this.mySwitchAction.addSourceSwitchListener(listener);
        }
    }

    private static class MyMergeSourceAvailableMarkerGutter
    extends AnnotationFieldGutter
    implements Consumer<AnnotationSource> {
        private boolean myTurnedOn;

        private MyMergeSourceAvailableMarkerGutter(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation highlighting) {
            super(annotation, editor, aspect, highlighting);
        }

        @Override
        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        @Override
        public String getLineText(int line, Editor editor) {
            if (this.myTurnedOn) {
                return "";
            }
            AnnotationSourceSwitcher switcher = this.myAnnotation.getAnnotationSourceSwitcher();
            if (switcher == null) {
                return "";
            }
            return switcher.mergeSourceAvailable(line) ? "M" : "";
        }

        public void consume(AnnotationSource annotationSource) {
            this.myTurnedOn = annotationSource.showMerged();
        }
    }

    private static class MyCurrentRevisionAnnotationFieldGutter
    extends AnnotationFieldGutter
    implements Consumer<AnnotationSource> {
        private boolean myTurnedOn;

        private MyCurrentRevisionAnnotationFieldGutter(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation highlighting) {
            super(annotation, editor, aspect, highlighting);
        }

        @Override
        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        @Override
        public String getLineText(int line, Editor editor) {
            String value = this.myAspect.getValue(line);
            if (String.valueOf(this.myAnnotation.getLineRevisionNumber(line)).equals(value)) {
                return "";
            }
            return this.myTurnedOn ? value : "";
        }

        @Override
        public String getToolTip(int line, Editor editor) {
            String aspectTooltip = this.myAspect.getTooltipText(line);
            if (aspectTooltip != null) {
                return aspectTooltip;
            }
            String text = this.getLineText(line, editor);
            return text == null || text.length() == 0 ? "" : VcsBundle.message((String)"annotation.original.revision.text", (Object[])new Object[]{text});
        }

        public void consume(AnnotationSource annotationSource) {
            this.myTurnedOn = annotationSource.showMerged();
        }
    }

    private static class MyHighlightedAdditionalColumn
    extends AnnotationFieldGutter {
        private final HighlightAnnotationsActions myHighlighting;

        private MyHighlightedAdditionalColumn(FileAnnotation annotation, Editor editor, LineAnnotationAspect aspect, TextAnnotationPresentation presentation, HighlightAnnotationsActions highlighting) {
            super(annotation, editor, aspect, presentation);
            this.myHighlighting = highlighting;
        }

        @Override
        public String getLineText(int line, Editor editor) {
            return this.myHighlighting.isLineBold(line) ? "*" : "";
        }
    }
}

