/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class AbstractShowDiffAction
extends AbstractVcsAction {
    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, vcsContext, this.getKey());
    }

    protected static void updateDiffAction(Presentation presentation, VcsContext vcsContext, VcsBackgroundableActions actionKey) {
        presentation.setEnabled(AbstractShowDiffAction.isEnabled(vcsContext, actionKey));
        presentation.setVisible(AbstractShowDiffAction.isVisible(vcsContext));
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected abstract VcsBackgroundableActions getKey();

    protected static boolean isVisible(VcsContext vcsContext) {
        AbstractVcs[] vcss;
        Project project = vcsContext.getProject();
        if (project == null) {
            return false;
        }
        for (AbstractVcs vcs : vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()) {
            if (vcs.getDiffProvider() == null) continue;
            return true;
        }
        return false;
    }

    protected static boolean isEnabled(VcsContext vcsContext, VcsBackgroundableActions actionKey) {
        if (!AbstractShowDiffAction.isVisible(vcsContext)) {
            return false;
        }
        Project project = vcsContext.getProject();
        if (project == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile[] selectedFilePaths = vcsContext.getSelectedFiles();
        if (selectedFilePaths == null || selectedFilePaths.length != 1) {
            return false;
        }
        VirtualFile selectedFile = selectedFilePaths[0];
        if (selectedFile.isDirectory()) {
            return false;
        }
        BackgroundableActionEnabledHandler handler = ((ProjectLevelVcsManagerImpl)vcsManager).getBackgroundableActionHandler(actionKey);
        if (handler.isInProgress(VcsBackgroundableActions.keyFrom(selectedFile))) {
            return false;
        }
        AbstractVcs vcs = vcsManager.getVcsFor(selectedFile);
        if (vcs == null) {
            return false;
        }
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (diffProvider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)new FilePathImpl(selectedFile));
    }

    @Override
    protected void actionPerformed(VcsContext vcsContext) {
        Project project = vcsContext.getProject();
        VirtualFile selectedFile = vcsContext.getSelectedFiles()[0];
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs vcs = vcsManager.getVcsFor(selectedFile);
        DiffProvider diffProvider = vcs.getDiffProvider();
        DiffActionExecutor actionExecutor = this.getExecutor(diffProvider, selectedFile, project);
        actionExecutor.showDiff();
    }

    protected DiffActionExecutor getExecutor(DiffProvider diffProvider, VirtualFile selectedFile, Project project) {
        return new DiffActionExecutor.CompareToCurrentExecutor(diffProvider, selectedFile, project, this.getKey());
    }
}

