/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class LanguageLevelCombo
extends ComboBox {
    public static final String USE_PROJECT_LANGUAGE_LEVEL = ProjectBundle.message((String)"project.language.level.combo.item", (Object[])new Object[0]);

    public LanguageLevelCombo() {
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        this.setRenderer(new MyDefaultListCellRenderer());
    }

    public void reset(Project project) {
        this.setSelectedItem(LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel());
    }

    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            anObject = USE_PROJECT_LANGUAGE_LEVEL;
        }
        super.setSelectedItem(anObject);
    }

    private static class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        private MyDefaultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof LanguageLevel) {
                this.setText(((LanguageLevel)value).getPresentableText());
            } else if (value instanceof String) {
                this.setText((String)value);
            }
            return this;
        }
    }
}

