/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Icons;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class PathEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.PathEditor");
    public static final Color INVALID_COLOR = new Color(210, 0, 0);
    private JPanel myPanel;
    private JButton myRemoveButton;
    private JButton myAddButton;
    private JButton mySpecifyUrlButton;
    private JList myList;
    private DefaultListModel myModel;
    private final Set<VirtualFile> myAllFiles = new com.intellij.util.containers.HashSet();
    private boolean myModified = false;
    private boolean myEnabled = false;
    private static final Icon ICON_INVALID = IconLoader.getIcon((String)"/nodes/ppInvalid.png");
    private static final Icon ICON_EMPTY = IconLoader.getIcon((String)"/nodes/emptyNode.png");

    protected abstract boolean isShowUrlButton();

    protected abstract OrderRootType getRootType();

    protected abstract FileChooserDescriptor createFileChooserDescriptor();

    public abstract String getDisplayName();

    public Icon getIcon() {
        return null;
    }

    protected void setModified(boolean modified) {
        this.myModified = modified;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply(SdkModificator sdkModificator) {
        OrderRootType rootType = this.getRootType();
        sdkModificator.removeRoots(rootType);
        for (int i = 0; i < this.getRowCount(); ++i) {
            sdkModificator.addRoot(this.getValueAt(i), rootType);
        }
        this.setModified(false);
        this.updateButtons();
    }

    public VirtualFile[] getRoots() {
        int count = this.getRowCount();
        if (count == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] roots = new VirtualFile[count];
        for (int i = 0; i < count; ++i) {
            roots[i] = this.getValueAt(i);
        }
        return roots;
    }

    public void reset(VirtualFile[] files) {
        this.keepSelectionState();
        this.clearList();
        boolean bl = this.myEnabled = files != null;
        if (this.myEnabled) {
            for (int i = 0; i < files.length; ++i) {
                this.addElement(files[i]);
            }
        }
        this.setModified(false);
        this.updateButtons();
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new GridBagLayout());
        Insets anInsets = new Insets(2, 2, 2, 2);
        this.myModel = new DefaultListModel();
        this.myList = new JList(this.myModel);
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PathEditor.this.updateButtons();
            }
        });
        this.myList.setCellRenderer(new MyCellRenderer());
        this.myRemoveButton = new JButton(ProjectBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myAddButton = new JButton(ProjectBundle.message((String)"button.add", (Object[])new Object[0]));
        this.mySpecifyUrlButton = new JButton(ProjectBundle.message((String)"sdk.paths.specify.url.button", (Object[])new Object[0]));
        this.mySpecifyUrlButton.setVisible(this.isShowUrlButton());
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] added = PathEditor.this.doAdd();
                if (added.length > 0) {
                    PathEditor.this.setModified(true);
                }
                PathEditor.this.updateButtons();
                PathEditor.this.requestDefaultFocus();
                PathEditor.this.setSelectedRoots(added);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List removedItems = ListUtil.removeSelectedItems((JList)PathEditor.this.myList);
                PathEditor.this.itemsRemoved(removedItems);
            }
        });
        this.mySpecifyUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog(PathEditor.this.myPanel, PathEditor.this.getInitialValue());
                if (virtualFile != null) {
                    PathEditor.this.addElement(virtualFile);
                    PathEditor.this.setModified(true);
                    PathEditor.this.updateButtons();
                    PathEditor.this.requestDefaultFocus();
                    PathEditor.this.setSelectedRoots(new Object[]{virtualFile});
                }
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myList);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 8, 1.0, 1.0, 10, 1, anInsets, 0, 0));
        this.myPanel.add((Component)this.myAddButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, anInsets, 0, 0));
        this.myPanel.add((Component)this.myRemoveButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, anInsets, 0, 0));
        this.myPanel.add((Component)this.mySpecifyUrlButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, anInsets, 0, 0));
        this.myPanel.add(Box.createRigidArea(new Dimension(this.mySpecifyUrlButton.getPreferredSize().width, 4)), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, anInsets, 0, 0));
        return this.myPanel;
    }

    protected String getInitialValue() {
        return "";
    }

    private void itemsRemoved(List removedItems) {
        this.myAllFiles.removeAll(removedItems);
        if (removedItems.size() > 0) {
            this.setModified(true);
        }
        this.updateButtons();
        this.requestDefaultFocus();
    }

    private VirtualFile[] doAdd() {
        FileChooserDescriptor descriptor = this.createFileChooserDescriptor();
        VirtualFile[] files = FileChooser.chooseFiles((Component)this.myPanel, (FileChooserDescriptor)descriptor);
        files = this.adjustAddedFileSet(this.myPanel, files);
        ArrayList<VirtualFile> added = new ArrayList<VirtualFile>(files.length);
        for (int i = 0; i < files.length; ++i) {
            VirtualFile vFile = files[i];
            if (!this.addElement(vFile)) continue;
            added.add(vFile);
        }
        return VfsUtil.toVirtualFileArray(added);
    }

    protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
        return files;
    }

    private void updateButtons() {
        Object[] values = this.getSelectedRoots();
        this.myRemoveButton.setEnabled(values.length > 0 && this.myEnabled);
        this.myAddButton.setEnabled(this.myEnabled);
        this.mySpecifyUrlButton.setEnabled(this.myEnabled && !this.isUrlInserted());
        this.mySpecifyUrlButton.setVisible(this.isShowUrlButton());
    }

    private boolean isUrlInserted() {
        if (this.getRowCount() > 0) {
            return ((VirtualFile)this.myModel.lastElement()).getFileSystem() instanceof HttpFileSystem;
        }
        return false;
    }

    private void requestDefaultFocus() {
        if (this.myList != null) {
            this.myList.requestFocus();
        }
    }

    public void addPaths(VirtualFile ... paths) {
        boolean added = false;
        this.keepSelectionState();
        for (int i = 0; i < paths.length; ++i) {
            VirtualFile path = paths[i];
            if (!this.addElement(path)) continue;
            added = true;
        }
        if (added) {
            this.setModified(true);
            this.updateButtons();
        }
    }

    public void removePaths(VirtualFile ... paths) {
        HashSet<VirtualFile> pathsSet = new HashSet<VirtualFile>(Arrays.asList(paths));
        int size = this.getRowCount();
        TIntArrayList indicesToRemove = new TIntArrayList(paths.length);
        for (int idx = 0; idx < size; ++idx) {
            VirtualFile path = this.getValueAt(idx);
            if (!pathsSet.contains(path)) continue;
            indicesToRemove.add(idx);
        }
        List list = ListUtil.removeIndices((JList)this.myList, (int[])indicesToRemove.toNativeArray());
        this.itemsRemoved(list);
    }

    protected boolean addElement(VirtualFile item) {
        if (item == null) {
            return false;
        }
        if (this.myAllFiles.contains(item)) {
            return false;
        }
        if (this.isUrlInserted()) {
            this.myModel.insertElementAt(item, this.myModel.size() - 1);
        } else {
            this.myModel.addElement(item);
        }
        this.myAllFiles.add(item);
        return true;
    }

    private void setSelectedRoots(Object[] roots) {
        ArrayList<Object> rootsList = new ArrayList<Object>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            Object root = roots[i];
            if (root == null) continue;
            rootsList.add(root);
        }
        this.myList.getSelectionModel().clearSelection();
        int rowCount = this.myModel.getSize();
        for (int i = 0; i < rowCount; ++i) {
            Object currObject = this.myModel.get(i);
            LOG.assertTrue(currObject != null);
            if (!rootsList.contains(currObject)) continue;
            this.myList.getSelectionModel().addSelectionInterval(i, i);
        }
    }

    private void keepSelectionState() {
        final Object[] selectedItems = this.getSelectedRoots();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (selectedItems != null) {
                    PathEditor.this.setSelectedRoots(selectedItems);
                }
            }
        });
    }

    protected Object[] getSelectedRoots() {
        return this.myList.getSelectedValues();
    }

    private int getRowCount() {
        return this.myModel.getSize();
    }

    private VirtualFile getValueAt(int row) {
        return (VirtualFile)this.myModel.get(row);
    }

    public void clearList() {
        this.myModel.clear();
        this.myAllFiles.clear();
        this.setModified(true);
    }

    private static boolean isJarFile(final VirtualFile file) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                VirtualFile tempFile = file;
                if (file.getFileSystem() instanceof JarFileSystem && file.getParent() == null) {
                    String path = file.getPath().substring(0, file.getPath().length() - "!/".length());
                    tempFile = LocalFileSystem.getInstance().findFileByPath(path);
                }
                if (tempFile != null && !tempFile.isDirectory()) {
                    return FileTypeManager.getInstance().getFileTypeByFile(tempFile).equals(FileTypes.ARCHIVE);
                }
                return Boolean.FALSE;
            }
        });
    }

    private static Icon getIconForRoot(Object projectRoot) {
        if (projectRoot instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)projectRoot;
            if (!file.isValid()) {
                return ICON_INVALID;
            }
            if (PathEditor.isHttpRoot(file)) {
                return Icons.WEB_ICON;
            }
            return PathEditor.isJarFile(file) ? Icons.JAR_ICON : Icons.FILE_ICON;
        }
        return ICON_EMPTY;
    }

    private static boolean isHttpRoot(VirtualFile virtualFileOrProjectRoot) {
        if (virtualFileOrProjectRoot != null) {
            return virtualFileOrProjectRoot.getFileSystem() instanceof HttpFileSystem;
        }
        return false;
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        private String getPresentableString(final Object value) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return value instanceof VirtualFile ? ((VirtualFile)value).getPresentableUrl() : "UNKNOWN OBJECT";
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VirtualFile file;
            super.getListCellRendererComponent((JList<?>)list, this.getPresentableString(value), index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setForeground(UIUtil.getListSelectionForeground());
            } else if (value instanceof VirtualFile && !(file = (VirtualFile)value).isValid()) {
                this.setForeground(INVALID_COLOR);
            }
            this.setIcon(PathEditor.getIconForRoot(value));
            return this;
        }
    }
}

