/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleInsight {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.importProject.ModuleInsight");
    @NotNull
    private final ProgressIndicatorWrapper myProgress;
    private final Set<File> myEntryPointRoots = new HashSet<File>();
    private final List<Pair<File, String>> mySourceRoots = new ArrayList<Pair<File, String>>();
    private final Set<String> myIgnoredNames = new HashSet<String>();
    private final Map<File, Set<String>> mySourceRootToReferencedPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> mySourceRootToPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> myJarToPackagesMap = new HashMap<File, Set<String>>();
    private final StringInterner myInterner = new StringInterner();
    private final JavaLexer myLexer = new JavaLexer(LanguageLevel.JDK_1_5);
    private List<ModuleDescriptor> myModules;
    private List<LibraryDescriptor> myLibraries;

    public ModuleInsight(@Nullable ProgressIndicator progress) {
        this(progress, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public ModuleInsight(@Nullable ProgressIndicator progress, List<File> entryPointRoots, List<Pair<File, String>> sourceRoots, Set<String> ignoredNames) {
        this.myProgress = new ProgressIndicatorWrapper(progress);
        this.setRoots(entryPointRoots, sourceRoots, ignoredNames);
    }

    public final void setRoots(List<File> contentRoots, List<Pair<File, String>> sourceRoots, Set<String> ignoredNames) {
        this.myModules = null;
        this.myLibraries = null;
        this.myEntryPointRoots.clear();
        this.myEntryPointRoots.addAll(contentRoots);
        this.mySourceRoots.clear();
        this.mySourceRoots.addAll(sourceRoots);
        this.myIgnoredNames.clear();
        this.myIgnoredNames.addAll(ignoredNames);
        this.myJarToPackagesMap.clear();
        this.myInterner.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.myLibraries;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.myModules;
    }

    public void scanModules() {
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> contentRootToModules = new HashMap<File, ModuleDescriptor>();
        try {
            this.myProgress.pushState();
            for (Pair<File, String> pair : this.mySourceRoots) {
                File sourceRoot = (File)pair.getFirst();
                if (this.myIgnoredNames.contains(sourceRoot.getName())) continue;
                this.myProgress.setText("Scanning " + sourceRoot.getPath());
                HashSet<String> usedPackages = new HashSet<String>();
                this.mySourceRootToReferencedPackagesMap.put(sourceRoot, usedPackages);
                HashSet<String> selfPackages = new HashSet<String>();
                this.mySourceRootToPackagesMap.put(sourceRoot, selfPackages);
                this.scanSources(sourceRoot, (String)pair.getSecond(), usedPackages, selfPackages);
                usedPackages.removeAll(selfPackages);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText("Building modules layout...");
            for (File srcRoot : this.mySourceRootToPackagesMap.keySet()) {
                File moduleContentRoot = this.myEntryPointRoots.contains(srcRoot) ? srcRoot : srcRoot.getParentFile();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)contentRootToModules.get(moduleContentRoot);
                if (moduleDescriptor != null) {
                    moduleDescriptor.addSourceRoot(moduleContentRoot, srcRoot);
                    continue;
                }
                moduleDescriptor = new ModuleDescriptor(moduleContentRoot, new HashSet<File>(Collections.singleton(srcRoot)));
                contentRootToModules.put(moduleContentRoot, moduleDescriptor);
            }
            this.buildModuleDependencies(contentRootToModules);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException ignored) {
            // empty catch block
        }
        this.myModules = new ArrayList(contentRootToModules.values());
        HashSet<String> moduleNames = new HashSet<String>();
        for (ModuleDescriptor module : this.myModules) {
            String suggested = ModuleInsight.suggestUniqueName(moduleNames, module.getName());
            module.setName(suggested);
            moduleNames.add(suggested);
        }
    }

    private void buildModuleDependencies(Map<File, ModuleDescriptor> contentRootToModules) {
        Set<File> moduleContentRoots = contentRootToModules.keySet();
        for (File contentRoot : moduleContentRoots) {
            ModuleDescriptor checkedModule = contentRootToModules.get(contentRoot);
            this.myProgress.setText2("Building library dependencies for module " + checkedModule.getName());
            this.buildJarDependencies(checkedModule);
            this.myProgress.setText2("Building module dependencies for module " + checkedModule.getName());
            block1: for (File aContentRoot : moduleContentRoots) {
                ModuleDescriptor aModule = contentRootToModules.get(aContentRoot);
                if (checkedModule.equals(aModule)) continue;
                Set<File> aModuleRoots = aModule.getSourceRoots();
                for (File srcRoot : checkedModule.getSourceRoots()) {
                    Set<String> referencedBySourceRoot = this.mySourceRootToReferencedPackagesMap.get(srcRoot);
                    for (File aSourceRoot : aModuleRoots) {
                        if (!ContainerUtil.intersects(referencedBySourceRoot, (Collection)this.mySourceRootToPackagesMap.get(aSourceRoot))) continue;
                        checkedModule.addDependencyOn(aModule);
                        continue block1;
                    }
                }
            }
        }
    }

    private void buildJarDependencies(ModuleDescriptor module) {
        block0: for (File jarFile : this.myJarToPackagesMap.keySet()) {
            Set<String> jarPackages = this.myJarToPackagesMap.get(jarFile);
            for (File srcRoot : module.getSourceRoots()) {
                if (!ContainerUtil.intersects((Collection)this.mySourceRootToReferencedPackagesMap.get(srcRoot), jarPackages)) continue;
                module.addLibraryFile(jarFile);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File root : this.myEntryPointRoots) {
                    this.myProgress.setText("Scanning for libraries " + root.getPath());
                    this.scanRootForLibraries(root);
                }
            }
            catch (ProcessCanceledException ignored) {
                // empty catch block
            }
            this.myProgress.setText("Building initial libraries layout...");
            List<LibraryDescriptor> libraries = ModuleInsight.buildInitialLibrariesLayout(this.myJarToPackagesMap.keySet());
            HashSet<String> libNames = new HashSet<String>();
            for (LibraryDescriptor library : libraries) {
                Collection<File> libJars = library.getJars();
                String newName = ModuleInsight.suggestUniqueName(libNames, libJars.size() == 1 ? libJars.iterator().next().getName() : library.getName());
                library.setName(newName);
                libNames.add(newName);
            }
            this.myLibraries = libraries;
        }
        finally {
            this.myProgress.popState();
        }
    }

    private static String suggestUniqueName(Set<String> existingNames, String baseName) {
        String name = baseName;
        int index = 1;
        while (existingNames.contains(name)) {
            name = baseName + index++;
        }
        return name;
    }

    public void merge(ModuleDescriptor mainModule, ModuleDescriptor module) {
        for (File contentRoot : module.getContentRoots()) {
            File _contentRoot = ModuleInsight.appendContentRoot(mainModule, contentRoot);
            Set<File> sources = module.getSourceRoots(contentRoot);
            for (File source : sources) {
                mainModule.addSourceRoot(_contentRoot, source);
            }
        }
        for (File jar : module.getLibraryFiles()) {
            mainModule.addLibraryFile(jar);
        }
        for (ModuleDescriptor dependency : module.getDependencies()) {
            if (mainModule.equals(dependency)) continue;
            mainModule.addDependencyOn(dependency);
        }
        this.myModules.remove(module);
        for (ModuleDescriptor moduleDescr : this.myModules) {
            if (!moduleDescr.getDependencies().contains(module)) continue;
            moduleDescr.removeDependencyOn(module);
            if (moduleDescr.equals(mainModule)) continue;
            moduleDescr.addDependencyOn(mainModule);
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor library, String newLibraryName, Collection<File> jarsToExtract) {
        LibraryDescriptor newLibrary = new LibraryDescriptor(newLibraryName, jarsToExtract);
        this.myLibraries.add(newLibrary);
        library.removeJars(jarsToExtract);
        if (library.getJars().size() == 0) {
            this.removeLibrary(library);
        }
        return newLibrary;
    }

    public ModuleDescriptor splitModule(ModuleDescriptor descriptor, String newModuleName, Collection<File> contentsToExtract) {
        ModuleDescriptor newModule = null;
        for (File root : contentsToExtract) {
            HashSet sources = descriptor.removeContentRoot(root);
            if (newModule == null) {
                newModule = new ModuleDescriptor(root, sources != null ? sources : new HashSet());
                continue;
            }
            if (sources != null && sources.size() > 0) {
                for (File source : sources) {
                    newModule.addSourceRoot(root, source);
                }
                continue;
            }
            newModule.addContentRoot(root);
        }
        if (newModule == null) {
            return null;
        }
        newModule.setName(newModuleName);
        this.myModules.add(newModule);
        HashMap<File, ModuleDescriptor> contentRootToModule = new HashMap<File, ModuleDescriptor>();
        for (ModuleDescriptor module : this.myModules) {
            Set<File> roots = module.getContentRoots();
            for (File root : roots) {
                contentRootToModule.put(root, module);
            }
            module.clearModuleDependencies();
            module.clearLibraryFiles();
        }
        this.buildModuleDependencies(contentRootToModule);
        return newModule;
    }

    public void removeLibrary(LibraryDescriptor lib) {
        this.myLibraries.remove(lib);
    }

    public void moveJarsToLibrary(LibraryDescriptor from, Collection<File> files, LibraryDescriptor to) {
        to.addJars(files);
        from.removeJars(files);
        if (from.getJars().size() == 0) {
            this.removeLibrary(from);
        }
    }

    public LibraryDescriptor extractToNewLibrary(LibraryDescriptor from, Collection<File> jars, String libraryName) {
        LibraryDescriptor libraryDescriptor = new LibraryDescriptor(libraryName, new HashSet<File>());
        this.myLibraries.add(libraryDescriptor);
        this.moveJarsToLibrary(from, jars, libraryDescriptor);
        return libraryDescriptor;
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module) {
        HashSet<LibraryDescriptor> libs = new HashSet<LibraryDescriptor>();
        for (LibraryDescriptor library : this.myLibraries) {
            if (!ContainerUtil.intersects(library.getJars(), module.getLibraryFiles())) continue;
            libs.add(library);
        }
        return libs;
    }

    private static File appendContentRoot(ModuleDescriptor module, File contentRoot) {
        Set<File> moduleRoots = module.getContentRoots();
        for (File moduleRoot : moduleRoots) {
            try {
                if (FileUtil.isAncestor((File)moduleRoot, (File)contentRoot, (boolean)false)) {
                    return moduleRoot;
                }
                if (!FileUtil.isAncestor((File)contentRoot, (File)moduleRoot, (boolean)true)) continue;
                Set<File> currentSources = module.getSourceRoots(moduleRoot);
                module.removeContentRoot(moduleRoot);
                module.addContentRoot(contentRoot);
                for (File source : currentSources) {
                    module.addSourceRoot(contentRoot, source);
                }
                return contentRoot;
            }
            catch (IOException ignored) {
            }
        }
        module.addContentRoot(contentRoot);
        return contentRoot;
    }

    private static List<LibraryDescriptor> buildInitialLibrariesLayout(Set<File> jars) {
        HashMap<File, LibraryDescriptor> rootToLibraryMap = new HashMap<File, LibraryDescriptor>();
        for (File jar : jars) {
            File parent = jar.getParentFile();
            LibraryDescriptor lib = (LibraryDescriptor)rootToLibraryMap.get(parent);
            if (lib == null) {
                lib = new LibraryDescriptor(parent.getName(), new HashSet<File>());
                rootToLibraryMap.put(parent, lib);
            }
            lib.addJars(Collections.singleton(jar));
        }
        return new ArrayList<LibraryDescriptor>(rootToLibraryMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanSources(File fromRoot, String parentPackageName, Set<String> usedPackages, Set<String> selfPackages) {
        if (this.myIgnoredNames.contains(fromRoot.getName())) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            boolean includeParentName = false;
            for (File file : files) {
                if (file.isDirectory()) {
                    String subPackageName;
                    StringBuilder builder = StringBuilderSpinAllocator.alloc();
                    try {
                        builder.append(parentPackageName);
                        if (builder.length() > 0) {
                            builder.append(".");
                        }
                        builder.append(file.getName());
                        subPackageName = builder.toString();
                    }
                    finally {
                        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                    }
                    this.scanSources(file, subPackageName, usedPackages, selfPackages);
                    continue;
                }
                if (!StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".java")) continue;
                includeParentName = true;
                this.scanJavaFile(file, usedPackages);
            }
            if (includeParentName) {
                selfPackages.add(this.myInterner.intern(parentPackageName));
            }
        }
    }

    private void scanJavaFile(File file, Set<String> usedPackages) {
        this.myProgress.setText2(file.getName());
        try {
            char[] chars = FileUtil.loadFileText((File)file);
            this.scanImportStatements(chars, (Lexer)this.myLexer, usedPackages);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private void scanRootForLibraries(File fromRoot) {
        if (this.myIgnoredNames.contains(fromRoot.getName())) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanRootForLibraries(file);
                    continue;
                }
                String fileName = file.getName();
                if (!StringUtil.endsWithIgnoreCase((String)fileName, (String)".jar") && !StringUtil.endsWithIgnoreCase((String)fileName, (String)".zip") || this.myJarToPackagesMap.containsKey(file)) continue;
                HashSet<String> libraryPackages = new HashSet<String>();
                this.myJarToPackagesMap.put(file, libraryPackages);
                this.scanLibrary(file, libraryPackages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanLibrary(File file, Set<String> libraryPackages) {
        this.myProgress.pushState();
        this.myProgress.setText2(file.getName());
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String packageName;
                int index;
                String entryName = entries.nextElement().getName();
                if (!StringUtil.endsWithIgnoreCase((String)entryName, (String)".class") || (index = entryName.lastIndexOf(47)) <= 0 || libraryPackages.contains(packageName = entryName.substring(0, index).replace('/', '.'))) continue;
                libraryPackages.add(this.myInterner.intern(packageName));
            }
            zip.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (InternalError e) {
            LOG.info((Throwable)e);
        }
        finally {
            this.myProgress.popState();
        }
    }

    private void scanImportStatements(char[] text, Lexer lexer, Set<String> usedPackages) {
        lexer.start((CharSequence)new CharArrayCharSequence(text));
        ModuleInsight.skipWhiteSpaceAndComments(lexer);
        if (lexer.getTokenType() == JavaTokenType.PACKAGE_KEYWORD) {
            ModuleInsight.advanceLexer(lexer);
            if (ModuleInsight.readPackageName(text, lexer) == null) {
                return;
            }
        }
        while (true) {
            String packageName;
            if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
                ModuleInsight.advanceLexer(lexer);
            }
            if (lexer.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
                return;
            }
            ModuleInsight.advanceLexer(lexer);
            boolean isStaticImport = false;
            if (lexer.getTokenType() == JavaTokenType.STATIC_KEYWORD) {
                isStaticImport = true;
                ModuleInsight.advanceLexer(lexer);
            }
            if ((packageName = ModuleInsight.readPackageName(text, lexer)) == null) {
                return;
            }
            if (packageName.endsWith(".*")) {
                usedPackages.add(this.myInterner.intern(packageName.substring(0, packageName.length() - ".*".length())));
                continue;
            }
            int lastDot = packageName.lastIndexOf(46);
            if (lastDot <= 0) continue;
            String _packageName = packageName.substring(0, lastDot);
            if (isStaticImport) {
                lastDot = _packageName.lastIndexOf(46);
                String string = _packageName = lastDot > 0 ? _packageName.substring(0, lastDot) : null;
            }
            if (_packageName == null) continue;
            usedPackages.add(this.myInterner.intern(_packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readPackageName(char[] text, Lexer lexer) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (lexer.getTokenType() == JavaTokenType.IDENTIFIER || lexer.getTokenType() == JavaTokenType.ASTERISK) {
                buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd() - lexer.getTokenStart());
                ModuleInsight.advanceLexer(lexer);
                if (lexer.getTokenType() != JavaTokenType.DOT) break;
                buffer.append('.');
                ModuleInsight.advanceLexer(lexer);
            }
            String packageName = buffer.toString();
            if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.') || StringUtil.startsWithChar((CharSequence)packageName, (char)'*')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static void advanceLexer(Lexer lexer) {
        lexer.advance();
        ModuleInsight.skipWhiteSpaceAndComments(lexer);
    }

    private static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }
}

