/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeaBlueMetalTheme;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SideBorder2;
import com.intellij.ui.plaf.beg.BegBorders;
import com.intellij.ui.plaf.beg.BegButtonUI;
import com.intellij.ui.plaf.beg.BegCheckBoxUI;
import com.intellij.ui.plaf.beg.BegComboBoxUI;
import com.intellij.ui.plaf.beg.BegPopupMenuBorder;
import com.intellij.ui.plaf.beg.BegRadioButtonUI;
import com.intellij.ui.plaf.beg.BegTabbedPaneUI;
import com.intellij.ui.plaf.beg.BegTableUI;
import com.intellij.ui.plaf.beg.BegTreeUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="LafManager", roamingType=RoamingType.PER_PLATFORM, storages={@Storage(id="other", file="$APP_CONFIG$/options.xml")})
public final class LafManagerImpl
extends LafManager
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.LafManager");
    @NonNls
    private static final String IDEA_LAF_CLASSNAME = "idea.laf.classname";
    @NonNls
    private static final String HEAVY_WEIGHT_POPUP = "heavy";
    @NonNls
    private static final String MEDIUM_WEIGHT_POPUP = "medium";
    private final EventListenerList myListenerList;
    private final UIManager.LookAndFeelInfo[] myLafs;
    private UIManager.LookAndFeelInfo myCurrentLaf;
    @NonNls
    private static final String[] ourPatcheableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    @NonNls
    private static final String[] ourFileChooserTextKeys = new String[]{"FileChooser.viewMenuLabelText", "FileChooser.newFolderActionLabelText", "FileChooser.listViewActionLabelText", "FileChooser.detailsViewActionLabelText", "FileChooser.refreshActionLabelText"};
    private final HashMap<UIManager.LookAndFeelInfo, HashMap<String, Object>> myStoredDefaults = new HashMap();
    private final UISettings myUiSettings;
    @NonNls
    private static final String ELEMENT_LAF = "laf";
    @NonNls
    private static final String ATTRIBUTE_CLASS_NAME = "class-name";

    LafManagerImpl(UISettings uiSettings) {
        this.myUiSettings = uiSettings;
        this.myListenerList = new EventListenerList();
        IdeaLookAndFeelInfo ideaLaf = new IdeaLookAndFeelInfo();
        UIManager.LookAndFeelInfo[] installedLafs = UIManager.getInstalledLookAndFeels();
        this.myLafs = new UIManager.LookAndFeelInfo[1 + installedLafs.length];
        this.myLafs[0] = ideaLaf;
        System.arraycopy(installedLafs, 0, this.myLafs, 1, installedLafs.length);
        Arrays.sort(this.myLafs, new MyComparator());
        this.myCurrentLaf = this.getDefaultLaf();
    }

    public void addLafManagerListener(@NotNull LafManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/LafManagerImpl.addLafManagerListener must not be null");
        }
        this.myListenerList.add(LafManagerListener.class, l);
    }

    public void removeLafManagerListener(@NotNull LafManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/ui/LafManagerImpl.removeLafManagerListener must not be null");
        }
        this.myListenerList.remove(LafManagerListener.class, l);
    }

    private void fireLookAndFeelChanged() {
        LafManagerListener[] listeners;
        for (LafManagerListener listener : listeners = (LafManagerListener[])this.myListenerList.getListeners(LafManagerListener.class)) {
            listener.lookAndFeelChanged((LafManager)this);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("LafManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/ui/LafManagerImpl.getComponentName must not return null");
        }
        return "LafManager";
    }

    public void initComponent() {
        this.setCurrentLookAndFeel(this.findLaf(this.myCurrentLaf.getClassName()));
        this.updateUI();
    }

    public void disposeComponent() {
    }

    public void loadState(Element element) {
        UIManager.LookAndFeelInfo laf;
        boolean updateUI = this.myCurrentLaf != null;
        String className = null;
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (!ELEMENT_LAF.equals(child.getName())) continue;
            className = child.getAttributeValue(ATTRIBUTE_CLASS_NAME);
            break;
        }
        if ((laf = this.findLaf(className)) == null) {
            laf = this.getDefaultLaf();
        }
        this.myCurrentLaf = laf;
        if (updateUI) {
            this.setCurrentLookAndFeel(laf);
            this.updateUI();
        }
    }

    public Element getState() {
        Element element = new Element("state");
        if (this.myCurrentLaf.getClassName() != null) {
            Element child = new Element(ELEMENT_LAF);
            child.setAttribute(ATTRIBUTE_CLASS_NAME, this.myCurrentLaf.getClassName());
            element.addContent(child);
        }
        return element;
    }

    public UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return (UIManager.LookAndFeelInfo[])this.myLafs.clone();
    }

    public UIManager.LookAndFeelInfo getCurrentLookAndFeel() {
        return this.myCurrentLaf;
    }

    public boolean isUnderAquaLookAndFeel() {
        return "Mac OS X".equals(this.getCurrentLookAndFeel().getName());
    }

    public boolean isUnderQuaquaLookAndFeel() {
        return "Quaqua".equals(this.getCurrentLookAndFeel().getName());
    }

    private UIManager.LookAndFeelInfo getDefaultLaf() {
        UIManager.LookAndFeelInfo defaultLaf;
        if (SystemInfo.isMac) {
            UIManager.LookAndFeelInfo laf = this.findLaf(UIManager.getSystemLookAndFeelClassName());
            LOG.assertTrue(laf != null);
            return laf;
        }
        String defaultLafName = StartupUtil.getDefaultLAF();
        if (defaultLafName != null && (defaultLaf = this.findLaf(defaultLafName)) != null) {
            return defaultLaf;
        }
        return this.findLaf(IDEA_LAF_CLASSNAME);
    }

    private UIManager.LookAndFeelInfo findLaf(String className) {
        for (UIManager.LookAndFeelInfo laf : this.myLafs) {
            if (!Comparing.equal((String)laf.getClassName(), (String)className)) continue;
            return laf;
        }
        return null;
    }

    public void setCurrentLookAndFeel(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        PopupFactory popupFactory;
        LookAndFeel laf;
        if (this.findLaf(lookAndFeelInfo.getClassName()) == null) {
            LOG.error("unknown LookAndFeel : " + lookAndFeelInfo);
            return;
        }
        if (IDEA_LAF_CLASSNAME.equals(lookAndFeelInfo.getClassName())) {
            laf = new IdeaLaf();
            IdeaLaf.setCurrentTheme(new IdeaBlueMetalTheme());
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception exc) {
                Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            laf = (LookAndFeel)Class.forName(lookAndFeelInfo.getClassName()).newInstance();
            if (laf instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception exc) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.set.look.and.feel", (Object[])new Object[]{lookAndFeelInfo.getName()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.myCurrentLaf = lookAndFeelInfo;
        String popupWeight = System.getProperty("idea.popup.weight");
        if (popupWeight == null) {
            popupWeight = SystemInfo.isWindows ? HEAVY_WEIGHT_POPUP : MEDIUM_WEIGHT_POPUP;
        }
        if (SystemInfo.isMacOSLeopard) {
            popupWeight = HEAVY_WEIGHT_POPUP;
        }
        if (HEAVY_WEIGHT_POPUP.equals(popupWeight)) {
            popupFactory = new PopupFactory(){

                @Override
                public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
                    Point point = LafManagerImpl.this.fixPopupLocation(contents, x, y);
                    return new Popup(owner, contents, point.x, point.y){};
                }
            };
        } else if (MEDIUM_WEIGHT_POPUP.equals(popupWeight)) {
            popupFactory = new PopupFactory(){

                @Override
                public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
                    return this.createPopup(owner, contents, x, y);
                }

                private Popup createPopup(Component owner, Component contents, int x, int y) {
                    Point point = LafManagerImpl.this.fixPopupLocation(contents, x, y);
                    Popup popup = super.getPopup(owner, contents, point.x, point.y);
                    return popup;
                }
            };
        } else {
            throw new IllegalStateException("unknown value of property -Didea.popup.weight: " + popupWeight);
        }
        PopupFactory.setSharedInstance(popupFactory);
    }

    private Point fixPopupLocation(Component contents, int x, int y) {
        PointerInfo info;
        if (!(contents instanceof JToolTip)) {
            return new Point(x, y);
        }
        try {
            info = MouseInfo.getPointerInfo();
        }
        catch (InternalError e) {
            return new Point(x, y);
        }
        int deltaY = 0;
        if (info != null) {
            Point mouse = info.getLocation();
            deltaY = mouse.y - y;
        }
        Dimension size = contents.getPreferredSize();
        Rectangle rec = new Rectangle(new Point(x, y), size);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)rec);
        if (rec.y < y) {
            rec.y += deltaY;
        }
        return rec.getLocation();
    }

    public void updateUI() {
        Frame[] frames;
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        LafManagerImpl.initInputMapDefaults(lookAndFeelDefaults);
        this.patchFileChooserStrings(lookAndFeelDefaults);
        if (this.shouldPatchLAFFonts()) {
            this.storeOriginalFontDefaults(lookAndFeelDefaults);
            this.initFontDefaults(lookAndFeelDefaults);
        } else {
            this.restoreOriginalFontDefaults(lookAndFeelDefaults);
        }
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.updateUI(frame);
        }
        this.fireLookAndFeelChanged();
    }

    private void patchFileChooserStrings(UIDefaults defaults) {
        if (!defaults.containsKey(ourFileChooserTextKeys[0])) {
            for (String key : ourFileChooserTextKeys) {
                defaults.put(key, IdeBundle.message((String)key, (Object[])new Object[0]));
            }
        }
    }

    private void restoreOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults != null) {
            for (String resource : ourPatcheableFontResources) {
                defaults.put(resource, lfDefaults.get(resource));
            }
        }
    }

    private void storeOriginalFontDefaults(UIDefaults defaults) {
        UIManager.LookAndFeelInfo lf = this.getCurrentLookAndFeel();
        HashMap<String, Object> lfDefaults = this.myStoredDefaults.get(lf);
        if (lfDefaults == null) {
            lfDefaults = new HashMap();
            for (String resource : ourPatcheableFontResources) {
                lfDefaults.put(resource, defaults.get(resource));
            }
            this.myStoredDefaults.put(lf, lfDefaults);
        }
    }

    private boolean shouldPatchLAFFonts() {
        return this.getCurrentLookAndFeel().getName().startsWith("IDEA") || UISettings.getInstance().OVERRIDE_NONIDEA_LAF_FONTS;
    }

    private static void updateUI(Window window) {
        Window[] children;
        if (!window.isDisplayable()) {
            return;
        }
        SwingUtilities.updateComponentTreeUI(window);
        for (Window aChildren : children = window.getOwnedWindows()) {
            LafManagerImpl.updateUI(aChildren);
        }
    }

    public void repaintUI() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            LafManagerImpl.repaintUI(frame);
        }
    }

    private static void repaintUI(Window window) {
        Window[] children;
        if (!window.isDisplayable()) {
            return;
        }
        window.repaint();
        for (Window aChildren : children = window.getOwnedWindows()) {
            LafManagerImpl.repaintUI(aChildren);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(155, 130), "copy-to-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(155, 65), "paste-from-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(127, 65), "cut-to-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(67, 130), "copy-to-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(86, 130), "paste-from-clipboard");
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    private static void initInputMapDefaults(UIDefaults defaults) {
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textAreaInputMap);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(textFieldInputMap);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            LafManagerImpl.installCutCopyPasteShortcuts(passwordFieldInputMap);
        }
    }

    private void initFontDefaults(UIDefaults defaults) {
        defaults.put("Tree.ancestorInputMap", (Object)null);
        int uiFontSize = this.myUiSettings.FONT_SIZE;
        String uiFontFace = this.myUiSettings.FONT_FACE;
        FontUIResource font = new FontUIResource(uiFontFace, 0, uiFontSize);
        FontUIResource font1 = new FontUIResource("Serif", 0, uiFontSize);
        FontUIResource font3 = new FontUIResource("Monospaced", 0, uiFontSize);
        for (String fontResource : ourPatcheableFontResources) {
            defaults.put(fontResource, font);
        }
        defaults.put("PasswordField.font", font3);
        defaults.put("TextArea.font", font3);
        defaults.put("TextPane.font", font1);
        defaults.put("EditorPane.font", font1);
        defaults.put("TitledBorder.font", font);
    }

    private static final class IdeaLaf
    extends MetalLookAndFeel {
        private IdeaLaf() {
        }

        @Override
        protected void initComponentDefaults(UIDefaults table) {
            super.initComponentDefaults(table);
            LafManagerImpl.initInputMapDefaults(table);
            IdeaLaf.initIdeaDefaults(table);
        }

        @Override
        protected void initSystemColorDefaults(UIDefaults table) {
            super.initSystemColorDefaults(table);
        }

        private static void initIdeaDefaults(UIDefaults defaults) {
            defaults.put("Menu.maxGutterIconWidth", (Object)18);
            defaults.put("MenuItem.maxGutterIconWidth", (Object)18);
            defaults.put("MenuItem.acceleratorDelimiter", "-");
            defaults.put("TitledBorder.titleColor", IdeaBlueMetalTheme.primary1);
            ColorUIResource col = new ColorUIResource(230, 230, 230);
            defaults.put("ScrollBar.background", col);
            defaults.put("ScrollBar.track", col);
            defaults.put("TextField.border", BegBorders.getTextFieldBorder());
            defaults.put("PasswordField.border", BegBorders.getTextFieldBorder());
            BegPopupMenuBorder popupMenuBorder = new BegPopupMenuBorder();
            defaults.put("PopupMenu.border", popupMenuBorder);
            defaults.put("ScrollPane.border", BegBorders.getScrollPaneBorder());
            defaults.put("ButtonUI", BegButtonUI.class.getName());
            defaults.put("ComboBoxUI", BegComboBoxUI.class.getName());
            defaults.put("RadioButtonUI", BegRadioButtonUI.class.getName());
            defaults.put("CheckBoxUI", BegCheckBoxUI.class.getName());
            defaults.put("TabbedPaneUI", BegTabbedPaneUI.class.getName());
            defaults.put("TableUI", BegTableUI.class.getName());
            defaults.put("TreeUI", BegTreeUI.class.getName());
            defaults.put("TabbedPane.tabInsets", new Insets(0, 4, 0, 4));
            defaults.put("ToolTip.background", new ColorUIResource(255, 255, 231));
            defaults.put("ToolTip.border", new SideBorder2(Color.gray, Color.gray, Color.black, Color.black, 1));
            defaults.put("Tree.ancestorInputMap", (Object)null);
            defaults.put("FileView.directoryIcon", IconLoader.getIcon((String)"/nodes/folder.png"));
            defaults.put("FileChooser.upFolderIcon", IconLoader.getIcon((String)"/nodes/upFolder.png"));
            defaults.put("FileChooser.newFolderIcon", IconLoader.getIcon((String)"/nodes/newFolder.png"));
            defaults.put("FileChooser.homeFolderIcon", IconLoader.getIcon((String)"/nodes/homeFolder.png"));
            defaults.put("OptionPane.errorIcon", IconLoader.getIcon((String)"/general/errorDialog.png"));
            defaults.put("OptionPane.informationIcon", IconLoader.getIcon((String)"/general/informationDialog.png"));
            defaults.put("OptionPane.warningIcon", IconLoader.getIcon((String)"/general/warningDialog.png"));
            defaults.put("OptionPane.questionIcon", IconLoader.getIcon((String)"/general/questionDialog.png"));
            defaults.put("Tree.openIcon", LookAndFeel.makeIcon(WindowsLookAndFeel.class, "icons/TreeOpen.gif"));
            defaults.put("Tree.closedIcon", LookAndFeel.makeIcon(WindowsLookAndFeel.class, "icons/TreeClosed.gif"));
            defaults.put("Tree.leafIcon", LookAndFeel.makeIcon(WindowsLookAndFeel.class, "icons/TreeLeaf.gif"));
            defaults.put("Tree.expandedIcon", WindowsTreeUI.ExpandedIcon.createExpandedIcon());
            defaults.put("Tree.collapsedIcon", WindowsTreeUI.CollapsedIcon.createCollapsedIcon());
            defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "F2", "startEditing"}));
        }
    }

    private static final class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            String name1 = ((UIManager.LookAndFeelInfo)obj1).getName();
            String name2 = ((UIManager.LookAndFeelInfo)obj2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    private static final class IdeaLookAndFeelInfo
    extends UIManager.LookAndFeelInfo {
        public IdeaLookAndFeelInfo() {
            super(IdeBundle.message((String)"idea.default.look.and.feel", (Object[])new Object[0]), LafManagerImpl.IDEA_LAF_CLASSNAME);
        }

        public boolean equals(Object obj) {
            return obj instanceof IdeaLookAndFeelInfo;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

