/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class CallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int myUsageCount = 1;
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private final boolean myNavigateToReference;

    public CallHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PsiElement element, boolean isBase, boolean navigateToReference) {
        super(project, parentDescriptor, element, isBase);
        this.myNavigateToReference = navigateToReference;
    }

    public final PsiMember getEnclosingElement() {
        return this.myElement == null ? null : CallHierarchyNodeDescriptor.getEnclosingElement(this.myElement);
    }

    static PsiMember getEnclosingElement(PsiElement element) {
        return (PsiMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
    }

    public final void incrementUsageCount() {
        ++this.myUsageCount;
    }

    public final PsiElement getTargetElement() {
        return this.myElement;
    }

    @Override
    public final boolean isValid() {
        PsiMember element = this.getEnclosingElement();
        return element != null && element.isValid();
    }

    @Override
    public final boolean update() {
        PsiFile file;
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldOpenIcon = this.myOpenIcon;
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiMember enclosingElement = this.getEnclosingElement();
        if (enclosingElement == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        this.myOpenIcon = enclosingElement.getIcon(flags);
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(this.myOpenIcon, 0);
            icon.setIcon(BASE_POINTER_ICON, 1, -BASE_POINTER_ICON.getIconWidth() / 2, 0);
            this.myOpenIcon = icon;
        }
        this.myClosedIcon = this.myOpenIcon;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (enclosingElement instanceof PsiMethod) {
            if (enclosingElement instanceof JspHolderMethod) {
                file = enclosingElement.getContainingFile();
                this.myHighlightedText.getEnding().addText(file != null ? file.getName() : IdeBundle.message((String)"node.call.hierarchy.unknown.jsp", (Object[])new Object[0]), mainTextAttributes);
            } else {
                PsiMethod method = (PsiMethod)enclosingElement;
                StringBuilder buffer = new StringBuilder(128);
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null) {
                    buffer.append(ClassPresentationUtil.getNameForClass(containingClass, false));
                    buffer.append('.');
                }
                String methodText = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                buffer.append(methodText);
                this.myHighlightedText.getEnding().addText(buffer.toString(), mainTextAttributes);
            }
        } else if (JspPsiUtil.isInJspFile((PsiElement)enclosingElement) && enclosingElement instanceof PsiFile) {
            file = JspPsiUtil.getJspFile((PsiElement)enclosingElement);
            this.myHighlightedText.getEnding().addText(file.getName(), mainTextAttributes);
        } else {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass((PsiClass)enclosingElement, false), mainTextAttributes);
        }
        if (this.myUsageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.myUsageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        if (!JspPsiUtil.isInJspFile((PsiElement)enclosingElement) || !(enclosingElement instanceof PsiFile)) {
            String packageName = JavaHierarchyUtil.getPackageName(enclosingElement instanceof PsiMethod ? ((PsiMethod)enclosingElement).getContainingClass() : (PsiClass)enclosingElement);
            this.myHighlightedText.getEnding().addText("  (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.myOpenIcon, (Object)oldOpenIcon)) {
            changes = true;
        }
        return changes;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public boolean hasReference(PsiReference reference) {
        return this.myReferences.contains(reference);
    }

    public void navigate(boolean requestFocus) {
        if (!this.myNavigateToReference) {
            if (this.myElement instanceof Navigatable && ((Navigatable)this.myElement).canNavigate()) {
                ((Navigatable)this.myElement).navigate(requestFocus);
            }
            return;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement element = firstReference.getElement();
        if (element == null) {
            return;
        }
        PsiElement callElement = element.getParent();
        if (callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate()) {
            ((Navigatable)callElement).navigate(requestFocus);
        } else {
            PsiFile psiFile = callElement.getContainingFile();
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(psiFile.getVirtualFile(), requestFocus);
        }
        Editor editor = this.getEditor(callElement);
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            ArrayList highlighters = new ArrayList();
            for (PsiReference psiReference : this.myReferences) {
                PsiElement eachMethodCall;
                PsiElement eachElement = psiReference.getElement();
                if (eachElement == null || (eachMethodCall = eachElement.getParent()) == null) continue;
                TextRange textRange = eachMethodCall.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, highlighters);
            }
        }
    }

    @Nullable
    private Editor getEditor(PsiElement callElement) {
        FileEditor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(callElement.getContainingFile().getVirtualFile());
        if (editor instanceof TextEditor) {
            return ((TextEditor)editor).getEditor();
        }
        return null;
    }

    public boolean canNavigate() {
        PsiFile psiFile;
        if (!this.myNavigateToReference) {
            return this.myElement instanceof Navigatable && ((Navigatable)this.myElement).canNavigate();
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement callElement = firstReference.getElement().getParent();
        if (callElement == null || !callElement.isValid()) {
            return false;
        }
        return callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate() || (psiFile = callElement.getContainingFile()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }
}

