/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;

public class GenericDebuggerRunnerSettings
implements JDOMExternalizable,
DebuggingRunnerData {
    public String DEBUG_PORT = "";
    public int TRANSPORT = 0;
    public boolean LOCAL = true;

    public GenericDebuggerRunnerSettings() {
        try {
            this.DEBUG_PORT = DebuggerUtils.getInstance().findAvailableDebugAddress(0 == this.TRANSPORT);
        }
        catch (ExecutionException e) {
            this.DEBUG_PORT = "";
        }
    }

    public String getDebugPort() {
        return this.DEBUG_PORT;
    }

    public boolean isRemote() {
        return !this.LOCAL;
    }

    public void setLocal(boolean isLocal) {
        this.LOCAL = isLocal;
    }

    private void updateDefaultAddress() {
        boolean useDefaultPort = "".equals(this.DEBUG_PORT);
        if (this.getTransport() == 0) {
            try {
                Integer.parseInt(this.DEBUG_PORT);
            }
            catch (NumberFormatException e) {
                useDefaultPort = true;
            }
        }
        if (useDefaultPort) {
            try {
                this.DEBUG_PORT = DebuggerUtils.getInstance().findAvailableDebugAddress(this.getTransport() == 0);
            }
            catch (ExecutionException e) {
                this.DEBUG_PORT = "";
            }
        }
    }

    public void setDebugPort(String port) {
        this.DEBUG_PORT = port;
        this.updateDefaultAddress();
    }

    public void setTransport(int transport) {
        if (this.getTransport() != transport) {
            this.setDebugPort("");
        }
        this.TRANSPORT = transport;
        this.updateDefaultAddress();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.updateDefaultAddress();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public int getTransport() {
        if (this.LOCAL) {
            return DebuggerSettings.getInstance().DEBUGGER_TRANSPORT;
        }
        return this.TRANSPORT;
    }
}

