/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.make.MakeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class SourceFileFinder {
    private final Project myProject;
    private final CompileContext myCompileContext;
    private Map<VirtualFile, String> myProjectSourceRoots = null;

    public SourceFileFinder(Project project, CompileContext compileContext) {
        this.myProject = project;
        this.myCompileContext = compileContext;
    }

    public VirtualFile findSourceFile(String qualifiedName, String srcName) {
        PsiClass[] classes;
        int dollar = qualifiedName.indexOf(36);
        String outerQName = dollar >= 0 ? qualifiedName.substring(0, dollar) : qualifiedName;
        for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(outerQName, GlobalSearchScope.projectScope((Project)this.myProject))) {
            PsiFile file = aClass.getContainingFile();
            if (!srcName.equals(file.getName())) continue;
            return file.getVirtualFile();
        }
        String relativePath = MakeUtil.createRelativePathToSource(qualifiedName, srcName);
        Map<VirtualFile, String> dirs = this.getAllSourceRoots();
        if (!StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = "/" + relativePath;
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (VirtualFile virtualFile : dirs.keySet()) {
            VirtualFile file;
            String path;
            String prefix = dirs.get(virtualFile);
            if (prefix.length() > 0) {
                if (!FileUtil.startsWith((String)relativePath, (String)prefix)) continue;
                path = virtualFile.getPath() + relativePath.substring(prefix.length() - 1);
            } else {
                path = virtualFile.getPath() + relativePath;
            }
            if ((file = fs.findFileByPath(path)) == null) continue;
            return file;
        }
        return null;
    }

    private Map<VirtualFile, String> getAllSourceRoots() {
        if (this.myProjectSourceRoots == null) {
            this.myProjectSourceRoots = new HashMap();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    Module[] allModules;
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)SourceFileFinder.this.myProject).getFileIndex();
                    for (Module allModule : allModules = ModuleManager.getInstance((Project)SourceFileFinder.this.myProject).getModules()) {
                        VirtualFile[] sourceRoots;
                        for (VirtualFile sourceRoot : sourceRoots = SourceFileFinder.this.myCompileContext.getSourceRoots(allModule)) {
                            String packageName = fileIndex.getPackageNameByDirectory(sourceRoot);
                            SourceFileFinder.this.myProjectSourceRoots.put(sourceRoot, packageName == null || packageName.length() == 0 ? "" : "/" + packageName.replace('.', '/') + "/");
                        }
                    }
                }
            });
        }
        return this.myProjectSourceRoots;
    }
}

