/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;

public class NavigationLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.NavigationLinkHandler");

    public void handleLink(@NotNull String suffix, @NotNull Editor editor, @NotNull JEditorPane tooltip) {
        int offset;
        if (suffix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/hint/NavigationLinkHandler.handleLink must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/hint/NavigationLinkHandler.handleLink must not be null");
        }
        if (tooltip == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/NavigationLinkHandler.handleLink must not be null");
        }
        int pos = suffix.lastIndexOf(58);
        if (pos <= 0 || pos == suffix.length() - 1) {
            LOG.error("Malformed suffix: " + suffix);
            return;
        }
        String path = suffix.substring(0, pos);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (vFile == null) {
            LOG.error("Unknown file: " + path);
            return;
        }
        try {
            offset = Integer.parseInt(suffix.substring(pos + 1));
        }
        catch (NumberFormatException e) {
            LOG.error("Malformed suffix: " + suffix);
            return;
        }
        tooltip.setVisible(false);
        new OpenFileDescriptor(editor.getProject(), vFile, offset).navigate(true);
    }
}

