/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowJavaDocInfoAction
extends BaseCodeInsightAction
implements HintManagerImpl.ActionToIgnore,
DumbAware {
    @NonNls
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    @NonNls
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";

    public ShowJavaDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    protected CodeInsightActionHandler getHandler() {
        return new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/documentation/actions/ShowJavaDocInfoAction$1.invoke must not be null");
                }
                if (editor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/documentation/actions/ShowJavaDocInfoAction$1.invoke must not be null");
                }
                if (file == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/documentation/actions/ShowJavaDocInfoAction$1.invoke must not be null");
                }
                DocumentationManager.getInstance(project).showJavaDocInfo(editor, file, true);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (editor == null && element == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            if (!this.isValidForLookup()) {
                presentation.setEnabled(false);
            } else {
                presentation.setEnabled(true);
            }
        } else {
            if (editor != null) {
                PsiReference ref;
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (file == null) {
                    presentation.setEnabled(false);
                }
                if (element == null && file != null && (ref = file.findReferenceAt(editor.getCaretModel().getOffset())) instanceof PsiPolyVariantReference) {
                    element = ref.getElement();
                }
            }
            if (element != null) {
                presentation.setEnabled(true);
            }
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        final PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        try {
            if (project != null && editor != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_FEATURE);
                LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project).getActiveLookup();
                if (lookup != null) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
                }
                this.actionPerformedImpl(project, editor);
            } else if (project != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickjavadoc.ctrln");
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        DocumentationManager.getInstance(project).showJavaDocInfo(element, null);
                    }
                }, this.getCommandName(), null);
            }
        }
        catch (IndexNotReadyException e1) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Documentation is not available until indices are built");
        }
    }
}

