/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class InsertNewFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;
    private final PsiClass myClass;

    public InsertNewFix(PsiMethodCallExpression methodCall, PsiClass aClass) {
        this.myMethodCall = methodCall;
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("insert.new.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix.isAvailable must not be null");
        }
        return this.myMethodCall != null && this.myMethodCall.isValid() && this.myMethodCall.getManager().isInProject((PsiElement)this.myMethodCall);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethodCall.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethodCall.getProject()).getElementFactory();
        PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new X()", null);
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        assert (classReference != null);
        classReference.replace((PsiElement)factory.createClassReferenceElement(this.myClass));
        PsiExpressionList argumentList = newExpression.getArgumentList();
        assert (argumentList != null);
        argumentList.replace((PsiElement)this.myMethodCall.getArgumentList());
        this.myMethodCall.replace((PsiElement)newExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

