/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.DeclarationSearcher;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConvertReturnStatementsVisitor
implements ReturnStatementsVisitor {
    private final PsiElementFactory myFactory;
    private final PsiMethod myMethod;
    private final PsiType myTargetType;
    private final DeclarationSearcher mySearcher;
    private PsiReturnStatement myLatestReturn;
    private final String myDefaultValue;

    public ConvertReturnStatementsVisitor(PsiElementFactory factory, PsiMethod method, PsiType targetType) {
        this.myFactory = factory;
        this.myMethod = method;
        this.myTargetType = targetType;
        this.mySearcher = new DeclarationSearcher(this.myMethod, this.myTargetType);
        this.myDefaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)this.myTargetType);
    }

    @Override
    public void visit(List<PsiReturnStatement> returnStatements) throws IncorrectOperationException {
        PsiReturnStatement statement = this.replaceReturnStatements(returnStatements);
        if (statement != null) {
            this.myLatestReturn = statement;
        }
    }

    public PsiReturnStatement getLatestReturn() {
        return this.myLatestReturn;
    }

    private String generateValue(PsiElement stopElement) {
        PsiVariable variable = this.mySearcher.getDeclaration(stopElement);
        return variable != null ? variable.getName() : this.myDefaultValue;
    }

    public PsiReturnStatement createReturnInLastStatement() throws IncorrectOperationException {
        PsiCodeBlock body = this.myMethod.getBody();
        String value = this.generateValue((PsiElement)body.getRBrace());
        PsiReturnStatement returnStatement = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value + ";", (PsiElement)this.myMethod);
        return (PsiReturnStatement)body.addBefore((PsiElement)returnStatement, (PsiElement)body.getRBrace());
    }

    @Nullable
    public PsiReturnStatement replaceReturnStatements(List<PsiReturnStatement> currentStatements) throws IncorrectOperationException {
        PsiReturnStatement latestReplaced = null;
        for (PsiReturnStatement returnStatement : currentStatements) {
            if (returnStatement.getReturnValue() != null) continue;
            String value = this.generateValue((PsiElement)returnStatement);
            latestReplaced = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value + ";", returnStatement.getParent());
            returnStatement.replace((PsiElement)latestReplaced);
        }
        return latestReplaced;
    }
}

