/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AddExceptionToCatchFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement element = AddExceptionToCatchFix.findElement(file, offset);
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        ArrayList<PsiClassType> unhandledExceptions = new ArrayList<PsiClassType>(ExceptionUtil.collectUnhandledExceptions(element, null));
        ExceptionUtil.sortExceptionsByHierarchy(unhandledExceptions);
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        PsiCodeBlock catchBlockToSelect = null;
        try {
            if (tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                }
                catchBlockToSelect = tryStatement.getCatchBlocks()[0];
            } else {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    PsiCodeBlock codeBlock = AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                    if (catchBlockToSelect != null) continue;
                    catchBlockToSelect = codeBlock;
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        if (catchBlockToSelect != null) {
            TextRange range = SurroundWithUtil.getRangeToSelect(catchBlockToSelect);
            editor.getCaretModel().moveToOffset(range.getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static PsiCodeBlock addCatchStatement(PsiTryStatement tryStatement, PsiClassType exceptionType, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)tryStatement.getProject()).getElementFactory();
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)tryStatement.getProject());
        String name = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)exceptionType).names[0];
        name = styleManager.suggestUniqueVariableName(name, (PsiElement)tryStatement, false);
        PsiCatchSection catchSection = factory.createCatchSection(exceptionType, name, (PsiElement)file);
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            tryStatement.add((PsiElement)catchSection);
        } else {
            PsiCodeBlock finallyElement = finallyBlock;
            while (!(finallyElement instanceof PsiKeyword) && !"finally".equals(finallyElement.getText())) {
                finallyElement = finallyElement.getPrevSibling();
            }
            tryStatement.addBefore((PsiElement)catchSection, (PsiElement)finallyElement);
        }
        PsiParameter[] parameters = tryStatement.getCatchBlockParameters();
        parameters[parameters.length - 1].getTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)exceptionType));
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        return catchBlocks[catchBlocks.length - 1];
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix.isAvailable must not be null");
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = AddExceptionToCatchFix.findElement(file, offset);
        if (element == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.catch.clause.text", new Object[0]));
        return true;
    }

    private static PsiElement findElement(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class});
        if (parent == null || parent instanceof PsiMethod) {
            return null;
        }
        PsiTryStatement statement = (PsiTryStatement)parent;
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock.getTextRange().getStartOffset() <= offset && tryBlock.getTextRange().getEndOffset() > offset && !ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, statement.getParent()).isEmpty()) {
            return tryBlock;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.catch.clause.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix.getFamilyName must not return null");
        }
        return string;
    }
}

