/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectHighlightsUtil {
    private static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create((String)"com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil");
    private static final int STARTING_TREE_HEIGHT = 100;

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(PsiElement root, int startOffset, int endOffset) {
        List<PsiElement> list = CollectHighlightsUtil.getElementsInRange(root, startOffset, endOffset, false);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil.getElementsInRange must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset, boolean includeAllParents) {
        List<PsiElement> list;
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil.getElementsInRange must not be null");
        }
        PsiElement commonParent = CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset);
        if (commonParent == null) {
            list = new ArrayList<PsiElement>();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil.getElementsInRange must not return null");
            return list;
        }
        List<PsiElement> list2 = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent = commonParent;
        while (parent != null && parent != root) {
            list2.add(parent);
            parent = includeAllParents ? parent.getParent() : null;
        }
        list2.add(root);
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil.getElementsInRange must not return null");
    }

    private static List<PsiElement> getElementsToHighlight(PsiElement commonParent, final int startOffset, final int endOffset) {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final int currentOffset = commonParent.getTextRange().getStartOffset();
        final Condition[] filters = (Condition[])Extensions.getExtensions(EP_NAME);
        PsiElementVisitor visitor = new PsiElementVisitor(){
            int offset;
            final TIntArrayList starts;
            final List<PsiElement> elements;
            final List<PsiElement> children;
            {
                this.offset = currentOffset;
                this.starts = new TIntArrayList(100);
                this.elements = new ArrayList<PsiElement>(100);
                this.children = new ArrayList<PsiElement>(100);
            }

            public void visitElement(PsiElement element) {
                this.children.add(PsiUtilBase.NULL_PSI_ELEMENT);
                while (true) {
                    ProgressManager.checkCanceled();
                    PsiElement child = this.children.remove(this.children.size() - 1);
                    for (Condition filter : filters) {
                        if (filter.value((Object)element)) continue;
                        assert (child == PsiUtilBase.NULL_PSI_ELEMENT);
                        child = null;
                        break;
                    }
                    boolean startChildrenVisiting = false;
                    if (child == PsiUtilBase.NULL_PSI_ELEMENT) {
                        startChildrenVisiting = true;
                        child = element.getFirstChild();
                    }
                    if (child == null) {
                        if (startChildrenVisiting) {
                            this.offset += element.getTextLength();
                        }
                        if (this.elements.size() == 0) break;
                        int start = this.starts.remove(this.starts.size() - 1);
                        if (startOffset <= start && this.offset <= endOffset) {
                            result.add(element);
                        }
                        element = this.elements.remove(this.elements.size() - 1);
                        continue;
                    }
                    if (this.offset > endOffset) break;
                    this.starts.add(this.offset);
                    this.children.add(child.getNextSibling());
                    this.children.add(PsiUtilBase.NULL_PSI_ELEMENT);
                    this.elements.add(element);
                    element = child;
                }
            }
        };
        commonParent.accept(visitor);
        return result;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        LOG.assertTrue(commonParent != null);
        LOG.assertTrue(commonParent.getTextRange() != null);
        while (commonParent.getParent() != null && commonParent.getTextRange().equals((Object)commonParent.getParent().getTextRange())) {
            commonParent = commonParent.getParent();
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root, int offset) {
        if (root instanceof PsiFile) {
            return ((PsiFile)root).getViewProvider().findElementAt(offset, root.getLanguage());
        }
        return root.findElementAt(offset);
    }

    public static boolean shouldHighlightFile(@Nullable PsiFile psiFile) {
        ProblemHighlightFilter[] filters;
        if (psiFile == null) {
            return true;
        }
        for (ProblemHighlightFilter filter : filters = (ProblemHighlightFilter[])ProblemHighlightFilter.EP_NAME.getExtensions()) {
            if (filter.shouldHighlight(psiFile)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOutsideSourceRootJavaFile(@Nullable PsiFile psiFile) {
        return psiFile != null && psiFile.getFileType() == StdFileTypes.JAVA && CollectHighlightsUtil.isOutsideSourceRoot(psiFile);
    }

    public static boolean isOutsideSourceRoot(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        if (psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        return !projectFileIndex.isInSource(file) && !projectFileIndex.isInLibraryClasses(file);
    }
}

