/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.DisplayTestInfoExtractor;
import com.intellij.execution.junit2.info.PsiClassLocator;
import com.intellij.execution.junit2.info.TestInfo;
import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBasedInfo
extends TestInfo {
    private final DisplayTestInfoExtractor myClassInfo;
    private PsiClassLocator myClass;
    private String myComment = null;

    public ClassBasedInfo(DisplayTestInfoExtractor classInfo) {
        this.myClassInfo = classInfo;
    }

    protected void readClass(ObjectReader reader) {
        this.setClassName(reader.readLimitedString());
    }

    protected void setClassName(String name) {
        this.myClass = PsiClassLocator.fromQualifiedName(name);
        this.myComment = null;
    }

    @Override
    @Nullable
    public Location getLocation(Project project) {
        return this.myClass.getLocation(project);
    }

    @Override
    public String getComment() {
        if (this.myComment == null) {
            this.myComment = this.myClassInfo.getComment(this.myClass);
        }
        return this.myComment;
    }

    @Override
    public String getName() {
        return this.myClassInfo.getName(this.myClass);
    }
}

