/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.impl.BaseDomModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomModelFactory<T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends BaseDomModelFactory<Module, T, M, C> {
    protected DomModelFactory(@NotNull Class<T> aClass, Project project, @NonNls String name) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelFactory.<init> must not be null");
        }
        super(aClass, project, name);
    }

    @Override
    protected Module getModelScope(XmlFile file) {
        return ModuleUtil.findModuleForPsiElement(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Set<XmlFile> getConfigFiles(@Nullable C context) {
        Set<XmlFile> set;
        if (context == null) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelFactory.getConfigFiles must not return null");
            return set;
        }
        Object model = this.getModel(context);
        if (model == null) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelFactory.getConfigFiles must not return null");
            return set;
        }
        set = model.getConfigFiles();
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelFactory.getConfigFiles must not return null");
    }

    public List<DomFileElement<T>> getFileElements(M model) {
        ArrayList<DomFileElement<T>> list = new ArrayList<DomFileElement<T>>(model.getConfigFiles().size());
        for (XmlFile configFile : model.getConfigFiles()) {
            DomFileElement element = DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
            if (element == null) continue;
            list.add(element);
        }
        return list;
    }
}

