/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.io.URLUtil;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtil");
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String JAR = "jar";
    @NonNls
    private static final String MAILTO = "mailto";
    private static final String PROTOCOL_DELIMITER = ":";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.loadText must not be null");
        }
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());
        try {
            String string = new String(FileUtil.loadText((Reader)reader, (int)((int)file.getLength())));
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void saveText(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.saveText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.saveText must not be null");
        }
        Charset charset = file.getCharset();
        file.setBinaryContent(text.getBytes(charset.name()));
    }

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getRelativePath must not be null");
        }
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getRelativePath must not be null");
        }
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getName().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            String name = parent.getName();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return new String(chars);
    }

    public static void copyDirectory(Object requestor, @NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyDirectory must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyDirectory must not be null");
        }
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.createChildDirectory(requestor, child.getName());
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFile must not be null");
        }
        return VfsUtil.copyFile(requestor, file, toDir, file.getName());
    }

    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFile must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFile must not be null");
        }
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBinaryContent(file.contentsToByteArray());
        return newChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(@NotNull VirtualFile file, @NonNls @NotNull String resourceUrl) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFromResource must not be null");
        }
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFromResource must not be null");
        }
        InputStream out = VfsUtil.class.getResourceAsStream(resourceUrl);
        if (out == null) {
            throw new FileNotFoundException(resourceUrl);
        }
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes((InputStream)out);
            file.setBinaryContent(bytes);
        }
        finally {
            out.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] getCommonAncestors(@NotNull VirtualFile[] files) {
        VirtualFile[] virtualFileArray;
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getCommonAncestors must not be null");
        }
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
                if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.getCommonAncestors must not return null");
                return virtualFileArray;
            }
            VirtualFile[] path = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        Iterator i$ = map.values().iterator();
        while (true) {
            Iterator i$2;
            VirtualFile ancestor;
            Set filesSet;
            if (i$.hasNext()) {
                filesSet = (Set)i$.next();
                ancestor = null;
                i$2 = filesSet.iterator();
            } else {
                virtualFileArray = VfsUtil.toVirtualFileArray(ancestorsList);
                if (virtualFileArray != null) return virtualFileArray;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.getCommonAncestors must not return null");
            }
            while (i$2.hasNext()) {
                VirtualFile file = (VirtualFile)i$2.next();
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
    }

    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile[] maxLengthPath;
        VirtualFile[] minLengthPath;
        VirtualFile[] path2;
        if (file1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getCommonAncestor must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getCommonAncestor must not be null");
        }
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        VirtualFile[] path1 = VfsUtil.getPathComponents(file1);
        if (path1.length < (path2 = VfsUtil.getPathComponents(file2)).length) {
            minLengthPath = path1;
            maxLengthPath = path2;
        } else {
            minLengthPath = path2;
            maxLengthPath = path1;
        }
        int lastEqualIdx = -1;
        int i = 0;
        while (i < minLengthPath.length && minLengthPath[i].equals(maxLengthPath[i])) {
            lastEqualIdx = i++;
        }
        return lastEqualIdx == -1 ? null : minLengthPath[lastEqualIdx];
    }

    @NotNull
    private static VirtualFile[] getPathComponents(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getPathComponents must not be null");
        }
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        if (components == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.getPathComponents must not return null");
        }
        return components;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull String uri, VirtualFile base) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.findRelativeFile must not be null");
        }
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
        } else if (uri.startsWith("file:")) {
            uri = uri.substring("file:".length());
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = "/" + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/')) {
            file = LocalFileSystem.getInstance().findFileByPath(uri);
        } else if (SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = LocalFileSystem.getInstance().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = JarFileSystem.getInstance().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return LocalFileSystem.getInstance().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return LocalFileSystem.getInstance().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + "/" + uri);
            if (file == null) {
                return null;
            }
        }
        return file;
    }

    public static VirtualFile findFileByURL(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.findFileByURL must not be null");
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        return VfsUtil.findFileByURL(url, virtualFileManager);
    }

    public static VirtualFile findFileByURL(@NotNull URL url, @NotNull VirtualFileManager virtualFileManager) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.findFileByURL must not be null");
        }
        if (virtualFileManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.findFileByURL must not be null");
        }
        String vfUrl = VfsUtil.convertFromUrl(url);
        return virtualFileManager.findFileByUrl(vfUrl);
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.convertToURL must not be null");
        }
        if (vfsUrl.startsWith(JAR)) {
            LOG.error("jar: protocol not supported.");
            return null;
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split = vfsUrl.split("://");
        if (split.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split[0];
        String path = split[1];
        try {
            if (protocol.equals(FILE)) {
                return new URL(protocol, "", path);
            }
            return new URL(vfsUrl);
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occured:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.convertFromUrl must not be null");
        }
        String protocol = url.getProtocol();
        String path = url.getPath();
        if (protocol.equals(JAR)) {
            if (StringUtil.startsWithConcatenationOf((String)path, (String)FILE, (String)PROTOCOL_DELIMITER)) {
                try {
                    URL subURL = new URL(path);
                    path = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(VfsBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(VfsBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences((String)path);
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.convertFromUrl must not return null");
        }
        return string;
    }

    public static String urlToPath(@NonNls String url) {
        if (url == null) {
            return "";
        }
        return VirtualFileManager.extractPath(url);
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.pathToUrl must not be null");
        }
        String string = VirtualFileManager.constructUrl(FILE, path);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.pathToUrl must not return null");
        }
        return string;
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.virtualToIoFile must not be null");
        }
        File file2 = new File(PathUtil.toPresentableUrl(file.getUrl()));
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.virtualToIoFile must not return null");
        }
        return file2;
    }

    @NotNull
    public static IFile virtualToIFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.virtualToIFile must not be null");
        }
        IFile iFile = FileSystem.FILE_SYSTEM.createFile(PathUtil.toPresentableUrl(file.getUrl()));
        if (iFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.virtualToIFile must not return null");
        }
        return iFile;
    }

    public static VirtualFile copyFileRelative(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String relativePath) throws IOException {
        String token;
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFileRelative must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFileRelative must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.copyFileRelative must not be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    @NotNull
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        if (ideaUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.fixIDEAUrl must not be null");
        }
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals(JAR)) {
                s = "jar:file";
            }
            ideaUrl = s + ":/" + ideaUrl.substring(idx + 3);
        }
        String string = ideaUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.fixIDEAUrl must not return null");
        }
        return string;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.fixURLforIDEA must not be null");
        }
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfo.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.fixURLforIDEA must not return null");
        }
        return string;
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        File parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isAncestor must not be null");
        }
        File file2 = parent = strict ? file.getParentFile() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParentFile();
        }
        return false;
    }

    @Nullable
    public static String getPath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getPath must not be null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getPath must not be null");
        }
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (src != commonAncestor) {
                while (src.getParent() != commonAncestor) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                    assert (src != null);
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    public static boolean isValidName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.isValidName must not be null");
        }
        return name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    public static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        if (libraryRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.getUrlForLibraryRoot must not be null");
        }
        String path = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == FileTypes.ARCHIVE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path);
    }

    public static VirtualFile createChildSequent(Object requestor, @NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.createChildSequent must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.createChildSequent must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.createChildSequent must not be null");
        }
        String fileName = prefix + "." + extension;
        int i = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + i + "." + extension;
            ++i;
        }
        return dir.createChildData(requestor, fileName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String[] filterNames(@NotNull String[] names) {
        String[] stringArray;
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.filterNames must not be null");
        }
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            stringArray = names;
            if (names == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.filterNames must not return null");
            return stringArray;
        }
        String[] result = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        stringArray = result;
        if (result != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.filterNames must not return null");
    }

    public static boolean isBadName(String name) {
        return name == null || name.length() == 0 || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(final @NotNull String dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.createDirectories must not be null");
        }
        final Ref err = new Ref();
        VirtualFile result = ApplicationManager.getApplication().runWriteAction(new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    return VfsUtil.createDirectoryIfMissing(dir);
                }
                catch (IOException e) {
                    err.set((Object)e);
                    return null;
                }
            }
        });
        if (!err.isNull()) {
            throw (IOException)err.get();
        }
        return result;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull String dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.createDirectoryIfMissing must not be null");
        }
        return VfsUtil.doCreateDirectoriesIfMissing(FileUtil.toSystemIndependentName((String)dir));
    }

    private static VirtualFile doCreateDirectoriesIfMissing(String dir) throws IOException {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(dir);
        if (file == null) {
            int pos = dir.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(dir.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = dir.substring(pos + 1);
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> VirtualFile doActionAndRestoreEncoding(@NotNull VirtualFile fileBefore, @NotNull ThrowableComputable<VirtualFile, E> action) throws E {
        if (fileBefore == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.doActionAndRestoreEncoding must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.doActionAndRestoreEncoding must not be null");
        }
        Charset charsetBefore = EncodingManager.getInstance().getEncoding(fileBefore, true);
        VirtualFile fileAfter = null;
        try {
            VirtualFile virtualFile = fileAfter = (VirtualFile)action.compute();
            return virtualFile;
        }
        finally {
            Charset actual;
            if (fileAfter != null && !Comparing.equal((Object)(actual = EncodingManager.getInstance().getEncoding(fileAfter, true)), (Object)charsetBefore)) {
                EncodingManager.getInstance().setEncoding(fileAfter, charsetBefore);
            }
        }
    }

    public static void processFileRecursivelyWithoutIgnored(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFileRecursivelyWithoutIgnored must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFileRecursivelyWithoutIgnored must not be null");
        }
        final FileTypeManager ftm = FileTypeManager.getInstance();
        VfsUtil.processFilesRecursively(root, processor, new Convertor<VirtualFile, Boolean>(){

            public Boolean convert(VirtualFile vf) {
                return !ftm.isFileIgnored(vf.getName());
            }
        });
    }

    public static void processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor, @NotNull Convertor<VirtualFile, Boolean> directoryFilter) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFilesRecursively must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFilesRecursively must not be null");
        }
        if (directoryFilter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFilesRecursively must not be null");
        }
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(root);
        while (!queue.isEmpty()) {
            VirtualFile file = (VirtualFile)queue.removeFirst();
            if (!processor.process((Object)file)) {
                return;
            }
            if (!file.isDirectory() || !((Boolean)directoryFilter.convert((Object)file)).booleanValue()) continue;
            queue.addAll(Arrays.asList(file.getChildren()));
        }
    }

    public static boolean processFilesRecursively(@NotNull VirtualFile root, @NotNull Processor<VirtualFile> processor) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFilesRecursively must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processFilesRecursively must not be null");
        }
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(root);
        while (!queue.isEmpty()) {
            VirtualFile file = (VirtualFile)queue.removeFirst();
            if (!processor.process((Object)file)) {
                return false;
            }
            if (!file.isDirectory()) continue;
            queue.addAll(Arrays.asList(file.getChildren()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T processInputStream(@NotNull VirtualFile file, @NotNull Function<InputStream, T> function) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processInputStream must not be null");
        }
        if (function == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.processInputStream must not be null");
        }
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            Object object = function.fun((Object)stream);
            return (T)object;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static VirtualFile[] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        VirtualFile[] virtualFileArray;
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VfsUtil.toVirtualFileArray must not be null");
        }
        int size = files.size();
        if (size == 0) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.toVirtualFileArray must not return null");
            return virtualFileArray;
        }
        virtualFileArray = files.toArray(new VirtualFile[size]);
        if (virtualFileArray != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VfsUtil.toVirtualFileArray must not return null");
    }
}

