/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;

public class DiffApplication
implements ApplicationStarter {
    @Override
    public String getCommandName() {
        return "diff";
    }

    @Override
    public void premain(String[] args) {
        if (args.length != 3) {
            this.printHelp();
        }
    }

    private void printHelp() {
        System.err.println(DiffBundle.message("diff.application.usage.parameters.and.description", new Object[0]));
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main(String[] args) {
        try {
            String path1 = args[1];
            String path2 = args[2];
            VirtualFile file1 = this.findFile(path1);
            VirtualFile file2 = this.findFile(path2);
            SimpleDiffRequest request = SimpleDiffRequest.compareFiles(file1, file2, null);
            request.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
            DiffManager.getInstance().getIdeaDiffTool().show(request);
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private VirtualFile findFile(String path1) throws FileNotFoundException {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(new File(path1));
        if (vFile == null) {
            throw new FileNotFoundException(DiffBundle.message("cannot.file.file.error.message", path1));
        }
        return vFile;
    }
}

