/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class RunContentDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ui.RunContentDescriptor");
    private final ExecutionConsole myExecutionConsole;
    private final ProcessHandler myProcessHandler;
    private final JComponent myComponent;
    private final String myDisplayName;
    private final Icon myIcon;
    private Content myContent;
    private Runnable myRestarter;

    public RunContentDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, JComponent component, String displayName, Icon icon) {
        LOG.assertTrue(executionConsole != null || ApplicationManager.getApplication().isUnitTestMode());
        this.myExecutionConsole = executionConsole;
        this.myProcessHandler = processHandler;
        this.myComponent = component;
        this.myDisplayName = displayName;
        this.myIcon = icon;
        this.myComponent.putClientProperty("DataProvider", new DataProvider(){

            @Override
            public Object getData(@NonNls String dataId) {
                if (RunContentManager.RUN_CONTENT_DESCRIPTOR.is(dataId)) {
                    return RunContentDescriptor.this;
                }
                return null;
            }
        });
    }

    public RunContentDescriptor(ExecutionConsole executionConsole, ProcessHandler processHandler, JComponent component, String displayName) {
        this(executionConsole, processHandler, component, displayName, null);
    }

    public ExecutionConsole getExecutionConsole() {
        return this.myExecutionConsole;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myExecutionConsole);
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public boolean isContentReuseProhibited() {
        return false;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void setAttachedContent(Content content) {
        this.myContent = content;
    }

    public Content getAttachedContent() {
        return this.myContent;
    }

    public void setRestarter(Runnable runnable) {
        this.myRestarter = runnable;
    }

    public Runnable getRestarter() {
        return this.myRestarter;
    }
}

