/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationFactory {
    public static final Icon ADD_ICON = IconLoader.getIcon((String)"/general/add.png");
    private final ConfigurationType myType;

    protected ConfigurationFactory(@NotNull ConfigurationType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/ConfigurationFactory.<init> must not be null");
        }
        this.myType = type;
    }

    public RunConfiguration createConfiguration(String name, RunConfiguration template) {
        RunConfiguration newConfiguration = template.clone();
        newConfiguration.setName(name);
        return newConfiguration;
    }

    public abstract RunConfiguration createTemplateConfiguration(Project var1);

    public RunConfiguration createTemplateConfiguration(Project project, RunManager runManager) {
        return this.createTemplateConfiguration(project);
    }

    public String getName() {
        return this.myType.getDisplayName();
    }

    public Icon getAddIcon() {
        return ADD_ICON;
    }

    public Icon getIcon(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/configurations/ConfigurationFactory.getIcon must not be null");
        }
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.myType.getIcon();
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.myType;
        if (configurationType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/ConfigurationFactory.getType must not return null");
        }
        return configurationType;
    }

    public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
    }
}

