/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.XmlAttributeInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.AdvancedPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;
import org.intellij.plugins.intelliLang.inject.config.ui.TagPanel;
import org.intellij.plugins.intelliLang.util.LanguageTextField;

public class XmlAttributePanel
extends AbstractInjectionPanel<XmlAttributeInjection> {
    private JPanel myRoot;
    LanguagePanel myLanguagePanel;
    TagPanel myTagPanel;
    AdvancedPanel myAdvancedPanel;
    private EditorTextField myLocalName;
    private ComboBox myNamespace;

    public XmlAttributePanel(XmlAttributeInjection injection, Project project) {
        super(injection, project);
        this.$$$setupUI$$$();
        this.myNamespace.setModel(TagPanel.createNamespaceUriModel(project));
        this.init(injection.copy());
        this.myLocalName.getDocument().addDocumentListener((DocumentListener)new AbstractInjectionPanel.TreeUpdateListener());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    @Override
    protected void resetImpl() {
        this.myLocalName.setText(((XmlAttributeInjection)this.myOrigInjection).getAttributeName());
        this.myNamespace.getEditor().setItem(((XmlAttributeInjection)this.myOrigInjection).getAttributeNamespace());
    }

    @Override
    protected void apply(XmlAttributeInjection i) {
        i.setAttributeName(this.myLocalName.getText());
        i.setAttributeNamespace(this.getNamespace());
    }

    private String getNamespace() {
        String s = (String)this.myNamespace.getEditor().getItem();
        return s != null ? s : "";
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myTagPanel = new TagPanel(this.myProject, (AbstractTagInjection)this.myOrigInjection);
        this.myAdvancedPanel = new AdvancedPanel(this.myProject, this.myOrigInjection);
        this.myLocalName = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, ((XmlAttributeInjection)this.myOrigInjection).getAttributeName());
        this.myNamespace = new ComboBox(200);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TagPanel tagPanel = this.myTagPanel;
        JComponent jComponent = tagPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "XML Attribute", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Local Name:");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setDisplayedMnemonicIndex(1);
        jLabel.setToolTipText("Regular expression to match the attribute name, e.g. \"on.*\"");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Namespace:");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myLocalName;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        ComboBox comboBox = this.myNamespace;
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent2 = languagePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AdvancedPanel advancedPanel = this.myAdvancedPanel;
        JComponent jComponent3 = advancedPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        jLabel.setLabelFor((Component)editorTextField);
        jLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

