/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;

public class ConcatenationUtils {
    private ConcatenationUtils() {
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiJavaToken sign = expression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUS)) {
            return false;
        }
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            PsiExpression lhs = expression.getLOperand();
            return ConcatenationUtils.hasStringType(lhs) || ConcatenationUtils.hasStringType(rhs);
        }
        return type.equalsToText("java.lang.String");
    }

    private static boolean hasStringType(PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return type != null && type.equalsToText("java.lang.String");
    }
}

