/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsTree;
import com.intellij.cvsSupport2.cvsBrowser.LoginAbortedException;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.SelectCVSConfigurationStep;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectCvsElementStep
extends WizardStep {
    private CvsTree myCvsTree;
    private CvsRootConfiguration myConfiguration;
    private final SelectCVSConfigurationStep mySelectCVSConfigurationStep;
    private final Project myProject;
    private final boolean myShowFiles;
    private final int mySelectionMode;
    private final boolean myAllowRootSelection;
    private final boolean myShowModules;

    public SelectCvsElementStep(String title, CvsWizard wizard, Project project, SelectCVSConfigurationStep selectCVSConfigurationStep, boolean showFiles, int selectionMode, boolean allowRootSelection, boolean showModules) {
        super(title, wizard);
        this.myShowModules = showModules;
        this.mySelectCVSConfigurationStep = selectCVSConfigurationStep;
        this.myProject = project;
        this.myShowFiles = showFiles;
        this.mySelectionMode = selectionMode;
        this.myAllowRootSelection = allowRootSelection;
        this.init();
    }

    @Override
    public boolean nextIsEnabled() {
        return this.myCvsTree.getCurrentSelection().length > 0;
    }

    private boolean isLogged(CvsRootConfiguration selectedConfiguration) {
        final Ref errors = new Ref();
        LoginPerformer.MyProjectKnown performer = new LoginPerformer.MyProjectKnown(this.myProject, Collections.singletonList(selectedConfiguration), new Consumer<VcsException>(){

            public void consume(VcsException e) {
                errors.set((Object)Boolean.TRUE);
            }
        });
        boolean logged = performer.loginAll(new ModalityContextImpl(ModalityState.current(), false), false);
        return logged && errors.isNull();
    }

    @Override
    public boolean preNextCheck() {
        CvsRootConfiguration selectedConfiguration = this.mySelectCVSConfigurationStep.getSelectedConfiguration();
        return this.isLogged(selectedConfiguration);
    }

    @Override
    public boolean setActive() {
        CvsRootConfiguration selectedConfiguration = this.mySelectCVSConfigurationStep.getSelectedConfiguration();
        if (this.myCvsTree == null || !Comparing.equal((Object)this.myConfiguration, (Object)selectedConfiguration)) {
            this.myConfiguration = selectedConfiguration;
            if (this.myConfiguration == null) {
                return false;
            }
            if (this.myCvsTree != null) {
                this.myCvsTree.dispose();
            }
            this.myCvsTree = new CvsTree(this.myConfiguration, this.myProject, this.myShowFiles, this.mySelectionMode, this.myAllowRootSelection, this.myShowModules);
            this.getStepComponent().removeAll();
            this.getStepComponent().add((Component)this.myCvsTree, "Center");
            try {
                this.myCvsTree.init();
            }
            catch (LoginAbortedException ex) {
                return false;
            }
            this.myCvsTree.addSelectionObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    if ("Selection Changed".equals(arg)) {
                        SelectCvsElementStep.this.getWizard().updateStep();
                    } else if ("Login Aborted".equals(arg)) {
                        SelectCvsElementStep.this.myCvsTree = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectCvsElementStep.this.getWizard().goToPrevious();
                            }
                        });
                    }
                }
            });
        }
        return true;
    }

    @Override
    protected void dispose() {
        if (this.myCvsTree != null) {
            this.myCvsTree.deactivated();
        }
    }

    public CvsElement getSelectedCvsElement() {
        CvsElement[] selection = this.myCvsTree.getCurrentSelection();
        if (selection.length == 0) {
            return null;
        }
        return selection[0];
    }

    @Override
    protected JComponent createComponent() {
        return new JPanel(new BorderLayout());
    }

    public CvsElement[] getSelectedCvsElements() {
        return this.myCvsTree.getCurrentSelection();
    }

    @Override
    public Component getPreferredFocusedComponent() {
        return this.myCvsTree.getTree();
    }
}

