/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.config.ProxySettings;
import com.intellij.cvsSupport2.config.SshSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.connections.CvsConnectionUtil;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.cvsSupport2.connections.login.CvsLoginWorkerImpl;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProvider;
import com.intellij.cvsSupport2.connections.ssh.SSHPasswordProviderImpl;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtil;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.errorHandling.ErrorRegistry;
import com.intellij.cvsSupport2.javacvsImpl.io.ReadWriteStatistics;
import com.intellij.cvsSupport2.javacvsImpl.io.StreamLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.io.IStreamLogger;

public class SshConnectionSettings
extends CvsConnectionSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.connections.ssh.SshConnectionSettings");

    public SshConnectionSettings(CvsRootConfiguration cvsRootConfiguration) {
        super(cvsRootConfiguration);
    }

    @Override
    public int getDefaultPort() {
        return 22;
    }

    @Override
    protected IConnection createOriginalConnection(ErrorRegistry errorRegistry, CvsRootConfiguration cvsRootConfiguration) {
        return SshConnectionSettings.createSshConnection(cvsRootConfiguration, this, cvsRootConfiguration.SSH_CONFIGURATION);
    }

    public static IConnection createSshConnection(CvsRootConfiguration cvsRootConfiguration, CvsRootData settings, SshSettings sshConfiguration) {
        int timeout = CvsApplicationLevelConfiguration.getInstance().TIMEOUT * 1000;
        ProxySettings proxy_settings = cvsRootConfiguration.PROXY_SETTINGS;
        return CvsConnectionUtil.createSshConnection((CvsRootData)settings, (SshSettings)sshConfiguration, (ProxySettings)proxy_settings, (SSHPasswordProvider)SSHPasswordProviderImpl.getInstance(), (int)timeout);
    }

    public CvsLoginWorkerImpl getLoginWorker(ModalityContext executor, Project project) {
        return new MyLoginWorker(project, executor, this.myStringRepsentation, this);
    }

    public CommandException processException(CommandException t) {
        return t;
    }

    private class MyLoginWorker
    extends CvsLoginWorkerImpl<SshConnectionSettings> {
        private final String myCvsRoot;

        private MyLoginWorker(Project project, ModalityContext executor, String cvsRoot, SshConnectionSettings sshConnectionSettings2) {
            super(project, sshConnectionSettings2, executor);
            this.myCvsRoot = cvsRoot;
        }

        @Override
        protected void clearOldCredentials() {
            if (((SshConnectionSettings)SshConnectionSettings.this).getSshConfiguration().USE_PPK) {
                SSHPasswordProviderImpl.getInstance().removePPKPasswordFor(SshConnectionSettings.this.myStringRepsentation);
            } else {
                SSHPasswordProviderImpl.getInstance().removePasswordFor(SshConnectionSettings.this.myStringRepsentation);
            }
        }

        @Override
        protected void silentLoginImpl(boolean forceCheck) throws AuthenticationException {
            IConnection connection = SshConnectionSettings.this.createConnection(new ReadWriteStatistics());
            connection.open((IStreamLogger)new StreamLogger());
            try {
                connection.close();
            }
            catch (IOException e) {
                throw new AuthenticationException("IOException occurred", (Throwable)e);
            }
        }

        @Override
        public boolean promptForPassword() {
            return SshConnectionUtil.promptForPassword(SshConnectionSettings.this.getSshConfiguration(), this.myCvsRoot);
        }
    }
}

