/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.AddFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class AddHandler {
    private final Collection<VirtualFile> myAddedFiles;
    private final Collection<VirtualFile> myAllFiles;
    private final Collection<File> myIOFiles;
    private final Project myProject;
    private final CvsStorageComponent myCvsStorageComponent;

    public AddHandler(@NotNull Project project, CvsStorageComponent cvsStorageComponent) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/cvsSupport2/application/AddHandler.<init> must not be null");
        }
        this.myAddedFiles = new ArrayList<VirtualFile>();
        this.myAllFiles = new ArrayList<VirtualFile>();
        this.myIOFiles = new ArrayList<File>();
        this.myProject = project;
        this.myCvsStorageComponent = cvsStorageComponent;
    }

    public void addFile(VirtualFile file) {
        this.myAllFiles.add(file);
    }

    public void addFile(File file) {
        this.myIOFiles.add(file);
    }

    public void execute() {
        for (VirtualFile file : this.myAllFiles) {
            if (!CvsUtil.fileIsUnderCvs(file.getParent())) continue;
            if (CvsUtil.fileIsLocallyRemoved(file)) {
                CvsUtil.restoreFile(file);
                continue;
            }
            if (CvsUtil.fileIsUnderCvs(file) || CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParent()).isOffline()) continue;
            this.myAddedFiles.add(file);
        }
        if (!this.myAddedFiles.isEmpty() && CvsVcs2.getInstance(this.myProject).getAddConfirmation().getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            Runnable addRunnable = new Runnable(){

                @Override
                public void run() {
                    if (!AddHandler.this.myCvsStorageComponent.getIsActive()) {
                        return;
                    }
                    AddFileOrDirectoryAction.createActionToAddNewFileAutomatically().actionPerformed(AddHandler.this.createDataContext(AddHandler.this.myAddedFiles));
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                addRunnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(addRunnable);
            }
        }
    }

    private CvsContext createDataContext(final Collection<VirtualFile> files) {
        final Iterator<VirtualFile> first = files.iterator();
        return new CvsContextAdapter(){

            @Override
            public Project getProject() {
                return AddHandler.this.myProject;
            }

            @Override
            public VirtualFile getSelectedFile() {
                return first.hasNext() ? (VirtualFile)first.next() : null;
            }

            @Override
            public VirtualFile[] getSelectedFiles() {
                return VfsUtil.toVirtualFileArray((Collection)files);
            }
        };
    }
}

