/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.FragmentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.ElementPresentation;
import org.jetbrains.annotations.Nullable;

public class PsiDiffContentFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.ex.PsiDiffContentFactory");

    private PsiDiffContentFactory() {
    }

    @Nullable
    private static DiffContent fromPsiElement(PsiElement psiElement) {
        if (psiElement instanceof PsiFile) {
            return DiffContent.fromFile((Project)psiElement.getProject(), (VirtualFile)((PsiFile)psiElement).getVirtualFile());
        }
        if (psiElement instanceof PsiDirectory) {
            return DiffContent.fromFile((Project)psiElement.getProject(), (VirtualFile)((PsiDirectory)psiElement).getVirtualFile());
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            String text = psiElement.getText();
            return text != null ? new SimpleContent(text) : null;
        }
        FileContent wholeFileContent = DiffContent.fromFile((Project)psiElement.getProject(), (VirtualFile)containingFile.getVirtualFile());
        if (wholeFileContent == null || wholeFileContent.getDocument() == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return new FragmentContent((DiffContent)wholeFileContent, psiElement.getTextRange(), project);
    }

    @Nullable
    public static SimpleDiffRequest comparePsiElements(PsiElement psiElement1, PsiElement psiElement2) {
        if (!psiElement1.isValid() || !psiElement2.isValid()) {
            return null;
        }
        Project project = psiElement1.getProject();
        LOG.assertTrue(project == psiElement2.getProject());
        DiffContent content1 = PsiDiffContentFactory.fromPsiElement(psiElement1);
        DiffContent content2 = PsiDiffContentFactory.fromPsiElement(psiElement2);
        if (content1 == null || content2 == null) {
            return null;
        }
        ElementPresentation presentation1 = ElementPresentation.forElement((PsiElement)psiElement1);
        ElementPresentation presentation2 = ElementPresentation.forElement((PsiElement)psiElement2);
        String title = DiffBundle.message((String)"diff.element.qualified.name.vs.element.qualified.name.dialog.title", (Object[])new Object[]{presentation1.getQualifiedName(), presentation2.getQualifiedName()});
        SimpleDiffRequest diffRequest = new SimpleDiffRequest(project, title);
        diffRequest.setContents(content1, content2);
        diffRequest.setContentTitles(presentation1.getQualifiedName(), presentation2.getQualifiedName());
        return diffRequest;
    }
}

