/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.SelectInManager;
import com.intellij.ide.commander.Commander;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiUtilBase;

public final class CommanderSelectInTarget
extends SelectInTargetPsiWrapper {
    public CommanderSelectInTarget(Project project) {
        super(project);
    }

    public String toString() {
        return SelectInManager.COMMANDER;
    }

    protected boolean canSelect(PsiFileSystemItem file) {
        return file.getManager().isInProject((PsiElement)file);
    }

    protected void select(PsiElement element, boolean requestFocus) {
        PsiClass[] classes;
        while (!(element instanceof PsiFile || element instanceof PsiDirectory || element instanceof PsiClass && element.getParent() instanceof PsiFile)) {
            element = element.getParent();
        }
        if (element instanceof PsiJavaFile && (classes = ((PsiJavaFile)element).getClasses()).length > 0) {
            element = classes[0];
        }
        final PsiElement _element = element.getOriginalElement();
        this.selectElementInCommander(new Runnable(){

            @Override
            public void run() {
                Commander.getInstance(CommanderSelectInTarget.this.myProject).selectElementInLeftPanel(_element, PsiUtilBase.getVirtualFile((PsiElement)_element));
            }
        }, requestFocus);
    }

    private void selectElementInCommander(Runnable runnable, boolean requestFocus) {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (requestFocus) {
            windowManager.getToolWindow(ToolWindowId.COMMANDER).activate(runnable);
        } else {
            runnable.run();
        }
    }

    protected void select(final Object selector, final VirtualFile virtualFile, boolean requestFocus) {
        this.selectElementInCommander(new Runnable(){

            @Override
            public void run() {
                Commander commander = Commander.getInstance(CommanderSelectInTarget.this.myProject);
                commander.selectElementInLeftPanel(selector, virtualFile);
            }
        }, requestFocus);
    }

    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    public String getToolWindowId() {
        return ToolWindowId.COMMANDER;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 5.0f;
    }
}

