/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.Nullable;

class TelemetryTableModel
extends DefaultTableModel {
    private final InspectionGadgetsTelemetry telemetry;
    private final NumberFormat format = NumberFormat.getNumberInstance();

    TelemetryTableModel(InspectionGadgetsTelemetry telemetry) {
        this.telemetry = telemetry;
        this.format.setMaximumFractionDigits(2);
        this.format.setMinimumFractionDigits(2);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Nullable
    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Long.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.telemetry == null) {
            return 0;
        }
        return this.telemetry.getInspections().length;
    }

    @Override
    @Nullable
    public Object getValueAt(int row, int column) {
        if (this.telemetry == null) {
            return null;
        }
        String[] inspections = this.telemetry.getInspections();
        String inspection = inspections[row];
        switch (column) {
            case 0: {
                return inspection;
            }
            case 1: {
                long totalRunTime = this.telemetry.getRunTimeForInspection(inspection);
                return totalRunTime;
            }
            case 2: {
                double averageRunTime = this.telemetry.getAverageRunTimeForInspection(inspection);
                return this.format.format(averageRunTime);
            }
            case 3: {
                int runCount = this.telemetry.getRunCountForInspection(inspection);
                return runCount;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int i, int i1) {
    }

    @Override
    @Nullable
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return InspectionGadgetsBundle.message("telemetry.table.column.inspection.name", new Object[0]);
            }
            case 1: {
                return InspectionGadgetsBundle.message("telemetry.table.column.total.time", new Object[0]);
            }
            case 2: {
                return InspectionGadgetsBundle.message("telemetry.table.column.average.time", new Object[0]);
            }
            case 3: {
                return InspectionGadgetsBundle.message("telemetry.table.column.run.count", new Object[0]);
            }
        }
        return null;
    }
}

