/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ExtendsObjectInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ExtendsObjectInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("ClassExplicitlyExtendsObject" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ExtendsObjectInspection.getID must not return null");
        }
        return "ClassExplicitlyExtendsObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("extends.object.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ExtendsObjectInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClassType[] types;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ExtendsObjectInspection$ExtendsObjectVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            for (PsiClassType type : types = aClass.getExtendsListTypes()) {
                if (!type.equalsToText("java.lang.Object")) continue;
                this.registerClassError(aClass, new Object[0]);
            }
        }
    }

    private static class ExtendsObjectFix
    extends InspectionGadgetsFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ExtendsObjectInspection$ExtendsObjectFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ExtendsObjectInspection$ExtendsObjectFix.doFix must not be null");
            }
            PsiElement extendClassIdentifier = descriptor.getPsiElement();
            PsiClass element = (PsiClass)extendClassIdentifier.getParent();
            if (element == null) {
                return;
            }
            PsiReferenceList extendsList = element.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                ExtendsObjectFix.deleteElement((PsiElement)referenceElement);
            }
        }
    }
}

