/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantOnLHSOfComparisonInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConstantOnLeftSideOfComparison" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConstantOnLHSOfComparisonInspection.getID must not return null");
        }
        return "ConstantOnLeftSideOfComparison";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConstantOnLHSOfComparisonInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConstantOnLHSOfComparisonInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnLHSOfComparisonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapComparisonFix();
    }

    private static class ConstantOnLHSOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnLHSOfComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ConstantOnLHSOfComparisonInspection$ConstantOnLHSOfComparisonVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (!this.isConstantExpression(lhs) || this.isConstantExpression(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean isConstantExpression(PsiExpression expression) {
            return ExpressionUtils.isNullLiteral(expression) || PsiUtil.isConstantExpression((PsiExpression)expression);
        }
    }

    private static class SwapComparisonFix
    extends InspectionGadgetsFix {
        private SwapComparisonFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("flip.comparision.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ConstantOnLHSOfComparisonInspection$SwapComparisonFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            String flippedComparison = ComparisonUtils.getFlippedComparison(sign);
            if (flippedComparison == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            String rhsText = rhs.getText();
            String lhsText = lhs.getText();
            SwapComparisonFix.replaceExpression((PsiExpression)expression, rhsText + ' ' + flippedComparison + ' ' + lhsText);
        }
    }
}

