/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoBoxingInspection
extends BaseInspection {
    public boolean ignoreAddedToCollection = false;
    @NonNls
    static final Map<String, String> s_boxingClasses = new HashMap<String, String>(8);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.boxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/AutoBoxingInspection.getDisplayName must not return null");
        }
        return string;
    }

    public String getAlternativeID() {
        return "boxing";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("auto.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/AutoBoxingInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("auto.boxing.ignore.added.to.collection.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAddedToCollection");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoBoxingVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AutoBoxingFix();
    }

    static {
        s_boxingClasses.put("byte", "java.lang.Byte");
        s_boxingClasses.put("short", "java.lang.Short");
        s_boxingClasses.put("int", "java.lang.Integer");
        s_boxingClasses.put("long", "java.lang.Long");
        s_boxingClasses.put("float", "java.lang.Float");
        s_boxingClasses.put("double", "java.lang.Double");
        s_boxingClasses.put("boolean", "java.lang.Boolean");
        s_boxingClasses.put("char", "java.lang.Character");
    }

    private class AutoBoxingVisitor
    extends BaseInspectionVisitor {
        private AutoBoxingVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (element.getLanguage() != StdLanguages.JAVA) {
                return;
            }
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
                return;
            }
            super.visitElement(element);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
            super.visitArrayAccessExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            super.visitAssignmentExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(@NotNull PsiExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingVisitor.checkExpression must not be null");
            }
            if (expression.getParent() instanceof PsiParenthesizedExpression) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            if (expressionType.equals(PsiType.VOID)) {
                return;
            }
            if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
                return;
            }
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
            PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
            if (boxedType == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false);
            if (expectedType == null) {
                return;
            }
            if (ClassUtils.isPrimitive(expectedType)) {
                return;
            }
            if (!expectedType.isAssignableFrom((PsiType)boxedType)) {
                return;
            }
            if (AutoBoxingInspection.this.ignoreAddedToCollection && this.isAddedToCollection(expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean isAddedToCollection(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "set".equals(methodName) || "add".equals(methodName))) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Collection", "java.util.Map") != null;
        }
    }

    private static class AutoBoxingFix
    extends InspectionGadgetsFix {
        private AutoBoxingFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("auto.boxing.make.boxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk/AutoBoxingInspection$AutoBoxingFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String classToConstruct;
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false);
            if (expectedType == null) {
                return;
            }
            String expectedTypeText = expectedType.getCanonicalText();
            if (s_boxingClasses.containsValue(expectedTypeText)) {
                classToConstruct = expectedTypeText;
            } else {
                PsiType type = expression.getType();
                if (type == null) {
                    return;
                }
                String expressionTypeText = type.getCanonicalText();
                classToConstruct = s_boxingClasses.get(expressionTypeText);
            }
            String newExpression = classToConstruct + ".valueOf(" + expression.getText() + ')';
            AutoBoxingFix.replaceExpression(expression, newExpression);
        }
    }
}

