/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AbstractMethodOverridesAbstractMethodInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AbstractMethodOverridesAbstractMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodOverridesAbstractMethodVisitor();
    }

    private static class AbstractMethodOverridesAbstractMethodVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodOverridesAbstractMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] superMethods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodVisitor.visitMethod must not be null");
            }
            if (method.isConstructor()) {
                return;
            }
            if (!AbstractMethodOverridesAbstractMethodVisitor.isAbstract(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!method.hasModifierProperty("abstract") && !containingClass.isInterface()) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                if (!AbstractMethodOverridesAbstractMethodVisitor.isAbstract(superMethod) || !AbstractMethodOverridesAbstractMethodVisitor.methodsHaveSameReturnTypes(method, superMethod) || !AbstractMethodOverridesAbstractMethodVisitor.haveSameExceptionSignatures(method, superMethod)) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean haveSameExceptionSignatures(PsiMethod method1, PsiMethod method2) {
            PsiReferenceList list2;
            PsiClassType[] exceptions2;
            PsiReferenceList list1 = method1.getThrowsList();
            PsiClassType[] exceptions1 = list1.getReferencedTypes();
            if (exceptions1.length != (exceptions2 = (list2 = method2.getThrowsList()).getReferencedTypes()).length) {
                return false;
            }
            HashSet<PsiClassType> set1 = new HashSet<PsiClassType>(Arrays.asList(exceptions1));
            for (PsiClassType anException : exceptions2) {
                if (set1.contains(anException)) continue;
                return false;
            }
            return true;
        }

        private static boolean methodsHaveSameReturnTypes(PsiMethod method1, PsiMethod method2) {
            PsiType type1 = method1.getReturnType();
            if (type1 == null) {
                return false;
            }
            PsiType type2 = method2.getReturnType();
            if (type2 == null) {
                return false;
            }
            return type1.equals(type2);
        }

        private static boolean isAbstract(PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            if (method.hasModifierProperty("abstract")) {
                return true;
            }
            if (containingClass == null) {
                return false;
            }
            return containingClass.isInterface();
        }
    }

    private static class AbstractMethodOverridesAbstractMethodFix
    extends InspectionGadgetsFix {
        private AbstractMethodOverridesAbstractMethodFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("abstract.method.overrides.abstract.method.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/AbstractMethodOverridesAbstractMethodInspection$AbstractMethodOverridesAbstractMethodFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement method = methodNameIdentifier.getParent();
            assert (method != null);
            AbstractMethodOverridesAbstractMethodFix.deleteElement(method);
        }
    }
}

