/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import org.jetbrains.annotations.NotNull;

public class ProtectedFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("protected.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ProtectedFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("protected.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ProtectedFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EncapsulateVariableFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedFieldVisitor();
    }

    private static class ProtectedFieldVisitor
    extends BaseInspectionVisitor {
        private ProtectedFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/encapsulation/ProtectedFieldInspection$ProtectedFieldVisitor.visitField must not be null");
            }
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

