/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;
    static final Set<String> bitwiseTokens = new HashSet<String>(6);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementExpression = this.calculateReplacementExpression((PsiExpression)infos[0]);
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.problem.descriptor", replacementExpression);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.bitwise.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    String calculateReplacementExpression(PsiExpression expression) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiExpression rhs = binaryExpression.getROperand();
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        assert (rhs != null);
        if (tokenType.equals(JavaTokenType.AND)) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType.equals(JavaTokenType.OR)) {
            if (this.isZero(lhs) || this.isAllOnes(rhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (tokenType.equals(JavaTokenType.XOR)) {
            if (this.isAllOnes(lhs)) {
                return '~' + rhs.getText();
            }
            if (this.isAllOnes(rhs)) {
                return '~' + lhs.getText();
            }
            if (this.isZero(rhs)) {
                return lhs.getText();
            }
            return rhs.getText();
        }
        if (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) {
            return lhs.getText();
        }
        return "";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    private boolean isAllOnes(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return true;
        }
        if (value instanceof Long && (Long)value == -1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == -1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\uffff') {
            return true;
        }
        return value instanceof Byte && (Byte)value == -1;
    }

    static {
        bitwiseTokens.add("&");
        bitwiseTokens.add("|");
        bitwiseTokens.add("^");
        bitwiseTokens.add("<<");
        bitwiseTokens.add(">>");
        bitwiseTokens.add(">>>");
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            String signText = sign.getText();
            if (!bitwiseTokens.contains(signText)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return;
            }
            if (rhsType.equals(PsiType.BOOLEAN) || rhsType.equalsToText("java.lang.Boolean")) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return;
            }
            if (lhsType.equals(PsiType.BOOLEAN) || lhsType.equalsToText("java.lang.Boolean")) {
                return;
            }
            IElementType tokenType = sign.getTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.AND) ? this.andExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.OR) ? this.orExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.XOR) ? this.xorExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT) ? this.shiftExpressionIsPointless(rhs) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean andExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBitwiseExpressionInspection.this.isZero(lhs) || PointlessBitwiseExpressionInspection.this.isZero(rhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(rhs);
        }

        private boolean orExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBitwiseExpressionInspection.this.isZero(lhs) || PointlessBitwiseExpressionInspection.this.isZero(rhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(rhs);
        }

        private boolean xorExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessBitwiseExpressionInspection.this.isZero(lhs) || PointlessBitwiseExpressionInspection.this.isZero(rhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(lhs) || PointlessBitwiseExpressionInspection.this.isAllOnes(rhs);
        }

        private boolean shiftExpressionIsPointless(PsiExpression rhs) {
            return PointlessBitwiseExpressionInspection.this.isZero(rhs);
        }
    }

    private class PointlessBitwiseFix
    extends InspectionGadgetsFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression);
            PointlessBitwiseFix.replaceExpression(expression, newExpression);
        }
    }
}

