/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class InstanceofChainInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ChainOfInstanceofChecks" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/InstanceofChainInspection.getID must not return null");
        }
        return "ChainOfInstanceofChecks";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/InstanceofChainInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/InstanceofChainInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofChainVisitor();
    }

    private static class InstanceofChainVisitor
    extends BaseInspectionVisitor {
        private InstanceofChainVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiIfStatement parentStatement;
            PsiStatement elseBranch;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/InstanceofChainInspection$InstanceofChainVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement && statement.equals(elseBranch = (parentStatement = (PsiIfStatement)parent).getElseBranch())) {
                return;
            }
            int numChecks = 0;
            PsiIfStatement branch = statement;
            while (branch != null) {
                PsiExpression condition = branch.getCondition();
                if (!InstanceofChainVisitor.isInstanceofCheck(condition)) {
                    return;
                }
                ++numChecks;
                PsiStatement elseBranch2 = branch.getElseBranch();
                if (elseBranch2 instanceof PsiIfStatement) {
                    branch = (PsiIfStatement)elseBranch2;
                    continue;
                }
                branch = null;
            }
            if (numChecks < 2) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean isInstanceofCheck(PsiExpression condition) {
            if (condition == null) {
                return false;
            }
            if (condition instanceof PsiInstanceOfExpression) {
                return true;
            }
            if (condition instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return InstanceofChainVisitor.isInstanceofCheck(lhs) && InstanceofChainVisitor.isInstanceofCheck(rhs);
            }
            if (condition instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return InstanceofChainVisitor.isInstanceofCheck(contents);
            }
            if (condition instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                PsiExpression contents = prefixExpression.getOperand();
                return InstanceofChainVisitor.isInstanceofCheck(contents);
            }
            if (condition instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition;
                PsiExpression contents = postfixExpression.getOperand();
                return InstanceofChainVisitor.isInstanceofCheck(contents);
            }
            return false;
        }
    }
}

