/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GantPositionManagerHelper
extends ScriptPositionManagerHelper {
    @Override
    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper.isAppropriateRuntimeName must not be null");
        }
        return true;
    }

    @Override
    public boolean isAppropriateScriptFile(@NotNull PsiFile scriptFile) {
        if (scriptFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper.isAppropriateScriptFile must not be null");
        }
        return GantUtils.isGantScriptFile(scriptFile);
    }

    @Override
    @NotNull
    public String getRuntimeScriptName(@NotNull String originalName, GroovyFile groovyFile) {
        if (originalName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper.getRuntimeScriptName must not be null");
        }
        String string = originalName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper.getRuntimeScriptName must not return null");
        }
        return string;
    }

    @Override
    public PsiFile getExtraScriptIfNotFound(ReferenceType refType, @NotNull String runtimeName, Project project) {
        if (runtimeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantPositionManagerHelper.getExtraScriptIfNotFound must not be null");
        }
        PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)(runtimeName + "." + "gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }
}

